/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.adapter.rxjava;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicBoolean;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.CompletableHelper;
import retrofit2.adapter.rxjava.OperatorMapResponseToBodyOrError;
import retrofit2.adapter.rxjava.Result;
import retrofit2.adapter.rxjava.SingleHelper;
import rx.Observable;
import rx.Producer;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.Exceptions;
import rx.functions.Func1;

public final class RxJavaCallAdapterFactory
extends CallAdapter.Factory {
    private final Scheduler scheduler;

    public static RxJavaCallAdapterFactory create() {
        return new RxJavaCallAdapterFactory(null);
    }

    public static RxJavaCallAdapterFactory createWithScheduler(Scheduler scheduler) {
        if (scheduler == null) {
            throw new NullPointerException("scheduler == null");
        }
        return new RxJavaCallAdapterFactory(scheduler);
    }

    private RxJavaCallAdapterFactory(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public CallAdapter<?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        Class rawType = RxJavaCallAdapterFactory.getRawType((Type)returnType);
        String canonicalName = rawType.getCanonicalName();
        boolean isSingle = "rx.Single".equals(canonicalName);
        boolean isCompletable = "rx.Completable".equals(canonicalName);
        if (rawType != Observable.class && !isSingle && !isCompletable) {
            return null;
        }
        if (!isCompletable && !(returnType instanceof ParameterizedType)) {
            String name = isSingle ? "Single" : "Observable";
            throw new IllegalStateException(name + " return type must be parameterized as " + name + "<Foo> or " + name + "<? extends Foo>");
        }
        if (isCompletable) {
            return CompletableHelper.createCallAdapter(this.scheduler);
        }
        CallAdapter<Observable<?>> callAdapter = this.getCallAdapter(returnType, this.scheduler);
        if (isSingle) {
            return SingleHelper.makeSingle(callAdapter);
        }
        return callAdapter;
    }

    private CallAdapter<Observable<?>> getCallAdapter(Type returnType, Scheduler scheduler) {
        Type observableType = RxJavaCallAdapterFactory.getParameterUpperBound((int)0, (ParameterizedType)((ParameterizedType)returnType));
        Class rawObservableType = RxJavaCallAdapterFactory.getRawType((Type)observableType);
        if (rawObservableType == Response.class) {
            if (!(observableType instanceof ParameterizedType)) {
                throw new IllegalStateException("Response must be parameterized as Response<Foo> or Response<? extends Foo>");
            }
            Type responseType = RxJavaCallAdapterFactory.getParameterUpperBound((int)0, (ParameterizedType)((ParameterizedType)observableType));
            return new ResponseCallAdapter(responseType, scheduler);
        }
        if (rawObservableType == Result.class) {
            if (!(observableType instanceof ParameterizedType)) {
                throw new IllegalStateException("Result must be parameterized as Result<Foo> or Result<? extends Foo>");
            }
            Type responseType = RxJavaCallAdapterFactory.getParameterUpperBound((int)0, (ParameterizedType)((ParameterizedType)observableType));
            return new ResultCallAdapter(responseType, scheduler);
        }
        return new SimpleCallAdapter(observableType, scheduler);
    }

    static final class ResultCallAdapter
    implements CallAdapter<Observable<?>> {
        private final Type responseType;
        private final Scheduler scheduler;

        ResultCallAdapter(Type responseType, Scheduler scheduler) {
            this.responseType = responseType;
            this.scheduler = scheduler;
        }

        public Type responseType() {
            return this.responseType;
        }

        public <R> Observable<Result<R>> adapt(Call<R> call) {
            Observable observable = Observable.create(new CallOnSubscribe<R>(call)).map(new Func1<Response<R>, Result<R>>(){

                public Result<R> call(Response<R> response) {
                    return Result.response(response);
                }
            }).onErrorReturn(new Func1<Throwable, Result<R>>(){

                public Result<R> call(Throwable throwable) {
                    return Result.error(throwable);
                }
            });
            if (this.scheduler != null) {
                return observable.subscribeOn(this.scheduler);
            }
            return observable;
        }
    }

    static final class SimpleCallAdapter
    implements CallAdapter<Observable<?>> {
        private final Type responseType;
        private final Scheduler scheduler;

        SimpleCallAdapter(Type responseType, Scheduler scheduler) {
            this.responseType = responseType;
            this.scheduler = scheduler;
        }

        public Type responseType() {
            return this.responseType;
        }

        public <R> Observable<R> adapt(Call<R> call) {
            Observable observable = Observable.create(new CallOnSubscribe<R>(call)).lift(OperatorMapResponseToBodyOrError.instance());
            if (this.scheduler != null) {
                return observable.subscribeOn(this.scheduler);
            }
            return observable;
        }
    }

    static final class ResponseCallAdapter
    implements CallAdapter<Observable<?>> {
        private final Type responseType;
        private final Scheduler scheduler;

        ResponseCallAdapter(Type responseType, Scheduler scheduler) {
            this.responseType = responseType;
            this.scheduler = scheduler;
        }

        public Type responseType() {
            return this.responseType;
        }

        public <R> Observable<Response<R>> adapt(Call<R> call) {
            Observable observable = Observable.create(new CallOnSubscribe<R>(call));
            if (this.scheduler != null) {
                return observable.subscribeOn(this.scheduler);
            }
            return observable;
        }
    }

    static final class RequestArbiter<T>
    extends AtomicBoolean
    implements Subscription,
    Producer {
        private final Call<T> call;
        private final Subscriber<? super Response<T>> subscriber;

        RequestArbiter(Call<T> call, Subscriber<? super Response<T>> subscriber) {
            this.call = call;
            this.subscriber = subscriber;
        }

        public void request(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("n < 0: " + n);
            }
            if (n == 0L) {
                return;
            }
            if (!this.compareAndSet(false, true)) {
                return;
            }
            try {
                Response response = this.call.execute();
                if (!this.subscriber.isUnsubscribed()) {
                    this.subscriber.onNext((Object)response);
                }
            }
            catch (Throwable t) {
                Exceptions.throwIfFatal((Throwable)t);
                if (!this.subscriber.isUnsubscribed()) {
                    this.subscriber.onError(t);
                }
                return;
            }
            if (!this.subscriber.isUnsubscribed()) {
                this.subscriber.onCompleted();
            }
        }

        public void unsubscribe() {
            this.call.cancel();
        }

        public boolean isUnsubscribed() {
            return this.call.isCanceled();
        }
    }

    static final class CallOnSubscribe<T>
    implements Observable.OnSubscribe<Response<T>> {
        private final Call<T> originalCall;

        CallOnSubscribe(Call<T> originalCall) {
            this.originalCall = originalCall;
        }

        public void call(Subscriber<? super Response<T>> subscriber) {
            Call call = this.originalCall.clone();
            RequestArbiter requestArbiter = new RequestArbiter(call, subscriber);
            subscriber.add(requestArbiter);
            subscriber.setProducer(requestArbiter);
        }
    }
}

