/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.plugin.hyperexpress;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.strategicgains.hyperexpress.HyperExpress;
import com.strategicgains.hyperexpress.ResourceFactoryStrategy;
import com.strategicgains.hyperexpress.domain.hal.HalResourceFactory;
import com.strategicgains.hyperexpress.domain.siren.SirenResourceFactory;
import com.strategicgains.hyperexpress.expand.Expander;
import com.strategicgains.hyperexpress.expand.ExpansionCallback;
import org.restexpress.RestExpress;
import org.restexpress.pipeline.Postprocessor;
import org.restexpress.pipeline.Preprocessor;
import org.restexpress.plugin.AbstractPlugin;
import org.restexpress.plugin.hyperexpress.HyperExpressPostprocessor;
import org.restexpress.plugin.hyperexpress.Linkable;
import org.restexpress.plugin.hyperexpress.RequestHeaderTokenBinder;

public class HyperExpressPlugin
extends AbstractPlugin {
    private Class<?> domainMarkerClass;
    private boolean usesCustomFactory = false;

    public HyperExpressPlugin() {
        this(Linkable.class);
    }

    public HyperExpressPlugin(Class<?> domainMarkerClass) {
        this.domainMarkerClass = domainMarkerClass;
    }

    public HyperExpressPlugin register(RestExpress server) {
        if (this.isRegistered()) {
            return this;
        }
        server.addPreprocessor((Preprocessor)new RequestHeaderTokenBinder()).addPostprocessor((Postprocessor)new HyperExpressPostprocessor(this.domainMarkerClass));
        return (HyperExpressPlugin)super.register(server);
    }

    public void bind(RestExpress server) {
        if (!this.usesCustomFactory) {
            HalResourceFactory hal = new HalResourceFactory();
            hal.excludeAnnotations(new Class[]{JsonIgnore.class});
            HyperExpress.registerResourceFactoryStrategy((ResourceFactoryStrategy)hal, (String)"application/json; charset=UTF-8");
            HyperExpress.registerResourceFactoryStrategy((ResourceFactoryStrategy)hal, (String)"application/hal+json; charset=UTF-8");
            SirenResourceFactory siren = new SirenResourceFactory();
            siren.excludeAnnotations(new Class[]{JsonIgnore.class});
            HyperExpress.registerResourceFactoryStrategy((ResourceFactoryStrategy)siren, (String)"application/vnd.siren+json; charset=UTF-8");
        }
        super.bind(server);
    }

    public HyperExpressPlugin addResourceFactory(ResourceFactoryStrategy factoryStrategy, String contentType) {
        HyperExpress.registerResourceFactoryStrategy((ResourceFactoryStrategy)factoryStrategy, (String)contentType);
        this.usesCustomFactory = true;
        return this;
    }

    public HyperExpressPlugin registerCallback(Class<?> type, ExpansionCallback callback) {
        Expander.registerCallback(type, (ExpansionCallback)callback);
        return this;
    }
}

