/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.plugin.hyperexpress;

import com.strategicgains.hyperexpress.HyperExpress;
import com.strategicgains.hyperexpress.domain.Resource;
import com.strategicgains.hyperexpress.exception.ResourceException;
import com.strategicgains.hyperexpress.expand.Expander;
import com.strategicgains.hyperexpress.expand.Expansion;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.restexpress.Request;
import org.restexpress.Response;
import org.restexpress.pipeline.Postprocessor;
import org.restexpress.plugin.hyperexpress.expand.ExpansionParser;

public class HyperExpressPostprocessor
implements Postprocessor {
    private Class<?> resourceMarker;

    public HyperExpressPostprocessor(Class<?> resourceMarkerClass) {
        this.resourceMarker = resourceMarkerClass;
    }

    public void process(Request request, Response response) {
        Object body = response.getBody();
        if (body == null || !response.isSerialized()) {
            return;
        }
        Resource resource = null;
        Class<?> bodyClass = body.getClass();
        Expansion expansion = ExpansionParser.parseFrom(request, response);
        try {
            if (this.isMarkerClass(bodyClass)) {
                resource = HyperExpress.createResource((Object)body, (String)expansion.getMediaType());
                Expander.expand((Expansion)expansion, bodyClass, (Resource)resource);
            } else if (this.isCollection(bodyClass)) {
                Type t;
                Type type = request.getResolvedRoute().getAction().getGenericReturnType();
                if (type instanceof ParameterizedType && this.resourceMarker.isAssignableFrom((Class)(t = ((ParameterizedType)type).getActualTypeArguments()[0]))) {
                    String componentRel = HyperExpress.relationships().getCollectionRelFor((Class)t);
                    resource = HyperExpress.createCollectionResource((Collection)((Collection)body), (Class)((Class)t), (String)componentRel, (String)expansion.getMediaType());
                    Expander.expand((Expansion)expansion, (Class)((Class)t), (List)resource.getResources(componentRel));
                }
            } else if (bodyClass.isArray() && this.isMarkerClass(bodyClass.getComponentType())) {
                String componentRel = HyperExpress.relationships().getCollectionRelFor(bodyClass.getComponentType());
                resource = HyperExpress.createCollectionResource(Arrays.asList((Object[])body), bodyClass.getComponentType(), (String)componentRel, (String)expansion.getMediaType());
                Expander.expand((Expansion)expansion, bodyClass.getComponentType(), (List)resource.getResources(componentRel));
            }
        }
        catch (ResourceException e) {
            // empty catch block
        }
        if (resource != null) {
            response.setBody(resource);
        }
        HyperExpress.clearTokenBindings();
    }

    private boolean isMarkerClass(Class<?> aClass) {
        return this.resourceMarker.isAssignableFrom(aClass);
    }

    private boolean isCollection(Class<?> aClass) {
        return Collection.class.isAssignableFrom(aClass);
    }
}

