/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.stripe.model.Event;
import com.stripe.net.UntypedMapDeserializer;
import java.lang.reflect.Type;
import java.util.Map;

public class EventDataDeserializer
implements JsonDeserializer<Event.Data> {
    private static final UntypedMapDeserializer UNTYPED_MAP_DESERIALIZER = new UntypedMapDeserializer();

    public Event.Data deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Event.Data eventData = new Event.Data();
        JsonObject jsonObject = json.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if ("previous_attributes".equals(key)) {
                if (element.isJsonNull()) {
                    eventData.setPreviousAttributes(null);
                    continue;
                }
                if (!element.isJsonObject()) continue;
                Map<String, Object> previousAttributes = UNTYPED_MAP_DESERIALIZER.deserialize(element.getAsJsonObject());
                eventData.setPreviousAttributes(previousAttributes);
                continue;
            }
            if (!"object".equals(key)) continue;
            eventData.setObject(((JsonElement)entry.getValue()).getAsJsonObject());
        }
        return eventData;
    }
}

