/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http;

import com.sun.grizzly.TransportFactory;
import com.sun.grizzly.http.FileCache;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.memory.MemoryManager;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.util.Interceptor;
import com.sun.grizzly.util.IntrospectionUtils;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

public class WebFilterConfig {
    public static final String SERVER_NAME = System.getProperty("product.name") != null ? System.getProperty("product.name") : "grizzly";
    protected FileCache fileCache;
    protected Adapter adapter = null;
    protected Interceptor interceptor;
    protected MemoryManager memoryManager;
    protected ExecutorService workerThreadPool;
    protected ScheduledExecutorService scheduledThreadPool;
    protected int maxKeepAliveRequests = 256;
    protected int keepAliveThreadCount = 1;
    protected String compression = "off";
    protected String noCompressionUserAgents = null;
    protected String restrictedUserAgents = null;
    protected String compressableMimeTypes = "text/html,text/xml,text/plain";
    private volatile String[] parsedCompressableMimeTypes = null;
    private volatile int parsedComressableMimeTypesHash = -1;
    protected int compressionMinSize = 2048;
    protected boolean isMonitoringEnabled = false;
    protected boolean isBufferResponse = false;
    protected int maxHttpHeaderSize = 8192;
    protected boolean isAsyncHttpWriteEnabled;
    protected int maxPostSize = 0x200000;
    protected int transactionTimeout = 300000;
    private boolean useChunking = true;
    private boolean enableNioLogging = false;
    protected boolean displayConfiguration = false;
    protected int requestBufferSize = 8192;
    protected int keepAliveTimeoutInSeconds = 30;
    protected String defaultResponseType = "text/plain; charset=iso-8859-1";
    protected String forcedRequestType = "text/plain; charset=iso-8859-1";
    private ClassLoader classLoader;
    protected String rootFolder = "";
    protected String serverName = SERVER_NAME;
    protected boolean disableUploadTimeout = true;
    protected int uploadTimeout = 30000;
    private Properties properties;

    public WebFilterConfig() {
        this.memoryManager = TransportFactory.getInstance().getDefaultMemoryManager();
        this.workerThreadPool = TransportFactory.getInstance().getDefaultWorkerThreadPool();
        this.scheduledThreadPool = TransportFactory.getInstance().getDefaultScheduledThreadPool();
        this.properties = new Properties();
    }

    public ProcessorTask initializeProcessorTask(ProcessorTask task) {
        task.setMaxHttpHeaderSize(this.maxHttpHeaderSize);
        task.setBufferSize(this.requestBufferSize);
        task.setDefaultResponseType(this.defaultResponseType);
        task.setForcedRequestType(this.forcedRequestType);
        task.setMaxPostSize(this.maxPostSize);
        task.setTimeout(this.uploadTimeout);
        task.setDisableUploadTimeout(this.disableUploadTimeout);
        task.setAsyncHttpWriteEnabled(this.isAsyncHttpWriteEnabled);
        task.setTransactionTimeout(this.transactionTimeout);
        task.setUseChunking(this.useChunking);
        task.setHandler(this.interceptor);
        this.initializeCompression(task);
        return task;
    }

    public void initializeCompression(ProcessorTask processorTask) {
        processorTask.addNoCompressionUserAgent(this.noCompressionUserAgents);
        this.parseComressableMimeTypes();
        processorTask.setCompressableMimeTypes(this.parsedCompressableMimeTypes);
        processorTask.setCompressionMinSize(this.compressionMinSize);
        processorTask.setCompression(this.compression);
        processorTask.addRestrictedUserAgent(this.restrictedUserAgents);
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public FileCache getFileCache() {
        return this.fileCache;
    }

    public void setFileCache(FileCache fileCache) {
        this.fileCache = fileCache;
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
    }

    public MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    public void setMemoryManager(MemoryManager memoryManager) {
        this.memoryManager = memoryManager;
    }

    public ScheduledExecutorService getScheduledThreadPool() {
        return this.scheduledThreadPool;
    }

    public void setScheduledThreadPool(ScheduledExecutorService scheduledThreadPool) {
        this.scheduledThreadPool = scheduledThreadPool;
    }

    public ExecutorService getWorkerThreadPool() {
        return this.workerThreadPool;
    }

    public void setWorkerThreadPool(ExecutorService workerThreadPool) {
        this.workerThreadPool = workerThreadPool;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getRootFolder() {
        return this.rootFolder;
    }

    public void setRootFolder(String rootFolder) {
        this.rootFolder = rootFolder;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.maxKeepAliveRequests = mkar;
    }

    public void setKeepAliveTimeoutInSeconds(int timeout) {
        this.keepAliveTimeoutInSeconds = timeout;
    }

    public int getKeepAliveTimeoutInSeconds() {
        return this.keepAliveTimeoutInSeconds;
    }

    public boolean isMonitoringEnabled() {
        return this.isMonitoringEnabled;
    }

    public void setMonitoringEnabled(boolean isMonitoringEnabled) {
        this.isMonitoringEnabled = isMonitoringEnabled;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int maxHttpHeaderSize) {
        this.maxHttpHeaderSize = maxHttpHeaderSize;
    }

    public boolean isAsyncHttpWriteEnabled() {
        return this.isAsyncHttpWriteEnabled;
    }

    public void setAsyncHttpWriteEnabled(boolean isAsyncHttpWriteEnabled) {
        this.isAsyncHttpWriteEnabled = isAsyncHttpWriteEnabled;
    }

    public void setRequestBufferSize(int requestBufferSize) {
        this.requestBufferSize = requestBufferSize;
    }

    public int getRequestBufferSize() {
        return this.requestBufferSize;
    }

    public void setWebAppRootPath(String rf) {
        this.rootFolder = rf;
    }

    public String getWebAppRootPath() {
        return this.rootFolder;
    }

    public boolean isBufferResponse() {
        return this.isBufferResponse;
    }

    public void setBufferResponse(boolean isBufferResponse) {
        this.isBufferResponse = isBufferResponse;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public String getNoCompressionUserAgents() {
        return this.noCompressionUserAgents;
    }

    public void setNoCompressionUserAgents(String noCompressionUserAgents) {
        this.noCompressionUserAgents = noCompressionUserAgents;
    }

    public String getRestrictedUserAgents() {
        return this.restrictedUserAgents;
    }

    public void setRestrictedUserAgents(String restrictedUserAgents) {
        this.restrictedUserAgents = restrictedUserAgents;
    }

    public String getCompressableMimeTypes() {
        return this.compressableMimeTypes;
    }

    public void setCompressableMimeTypes(String compressableMimeTypes) {
        this.compressableMimeTypes = compressableMimeTypes;
    }

    private void parseComressableMimeTypes() {
        if (this.compressableMimeTypes == null) {
            this.parsedCompressableMimeTypes = new String[0];
            return;
        }
        int hash = -1;
        hash = this.compressableMimeTypes.hashCode();
        if (hash == this.parsedComressableMimeTypesHash) {
            return;
        }
        ArrayList<String> compressableMimeTypeList = new ArrayList<String>(4);
        StringTokenizer st = new StringTokenizer(this.compressableMimeTypes, ",");
        while (st.hasMoreTokens()) {
            compressableMimeTypeList.add(st.nextToken().trim());
        }
        String[] tmpParsedCompressableMimeTypes = new String[compressableMimeTypeList.size()];
        compressableMimeTypeList.toArray(tmpParsedCompressableMimeTypes);
        this.parsedCompressableMimeTypes = tmpParsedCompressableMimeTypes;
        this.parsedComressableMimeTypesHash = hash;
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public void setCompressionMinSize(int compressionMinSize) {
        this.compressionMinSize = compressionMinSize;
    }

    public boolean isDisplayConfiguration() {
        return this.displayConfiguration;
    }

    public void setDisplayConfiguration(boolean displayConfiguration) {
        this.displayConfiguration = displayConfiguration;
    }

    public String getDefaultResponseType() {
        return this.defaultResponseType;
    }

    public void setDefaultResponseType(String defaultResponseType) {
        this.defaultResponseType = defaultResponseType;
    }

    public String getForcedRequestType() {
        return this.forcedRequestType;
    }

    public void setForcedRequestType(String forcedRequestType) {
        this.forcedRequestType = forcedRequestType;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public int getMaxPostSize() {
        return this.maxPostSize;
    }

    public void setMaxPostSize(int maxPostSize) {
        this.maxPostSize = maxPostSize;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public boolean isDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setUploadTimeout(int uploadTimeout) {
        this.uploadTimeout = uploadTimeout;
    }

    public int getUploadTimeout() {
        return this.uploadTimeout;
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public boolean isUseChunking() {
        return this.useChunking;
    }

    public void setUseChunking(boolean useChunking) {
        this.useChunking = useChunking;
    }

    public boolean isEnableNioLogging() {
        return this.enableNioLogging;
    }

    public void setEnableNioLogging(boolean enableNioLogging) {
        this.enableNioLogging = enableNioLogging;
    }

    private void configureProperties() {
        for (String string : this.properties.keySet()) {
            String value = this.properties.get(string).toString();
            IntrospectionUtils.setProperty((Object)this, (String)string, (String)value);
        }
    }
}

