/*
 * Decompiled with CFR 0.152.
 */
package sunmi.sunmiui.dialog;

import android.app.Dialog;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.util.Log;

abstract class BaseDialog
implements DialogInterface {
    private static final String TAG = "sunmiui";
    protected Dialog dialog;
    protected Resources resources;
    protected DialogInterface.OnCancelListener onCancelListener;

    BaseDialog() {
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
        this.resources = dialog.getContext().getResources();
        this.dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                if (BaseDialog.this.onCancelListener != null) {
                    BaseDialog.this.onCancelListener.onCancel((DialogInterface)BaseDialog.this);
                }
                BaseDialog.this.dialog = null;
                BaseDialog.this.onDialogCancel();
            }
        });
        this.init();
    }

    public void setSystemDialog(Dialog dialog) {
        this.dialog = dialog;
        this.dialog.getWindow().setType(2003);
        this.resources = dialog.getContext().getResources();
        this.dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                if (BaseDialog.this.onCancelListener != null) {
                    BaseDialog.this.onCancelListener.onCancel((DialogInterface)BaseDialog.this);
                }
                BaseDialog.this.dialog = null;
                BaseDialog.this.onDialogCancel();
            }
        });
        this.init();
    }

    public void show() {
        if (this.dialog != null && !this.dialog.isShowing()) {
            try {
                this.dialog.show();
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.e((String)TAG, (String)"show dialog fail!");
            }
        }
    }

    public void setOnCancelListener(DialogInterface.OnCancelListener listener) {
        this.onCancelListener = listener;
    }

    public void cancel() {
        if (this.dialog != null) {
            Log.i((String)"BaseDialog", (String)"dialog dismiss");
            this.dialog.cancel();
        }
    }

    public void onDestory() {
        if (this.dialog != null) {
            this.dialog = null;
        }
    }

    public void dismiss() {
        this.cancel();
    }

    public boolean hasDialog() {
        return this.dialog != null;
    }

    public void setCanceledOnTouchOutside(boolean b) {
        this.dialog.setCanceledOnTouchOutside(b);
    }

    public void setCancelable(boolean b) {
        this.dialog.setCancelable(b);
    }

    protected abstract void init();

    protected abstract void onDialogCancel();

    public Dialog getDialog() {
        return this.dialog;
    }
}

