/*
 * Decompiled with CFR 0.152.
 */
package sunmi.sunmiui.list;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import java.util.List;
import sunmi.sunmiui.R;
import sunmi.sunmiui.list.SunmiListAdapter;
import sunmi.sunmiui.list.SunmiListBean;
import sunmi.sunmiui.utils.Adaptation;

public class SunmiList
extends LinearLayout {
    private ListView mListView;
    private TextView mTvTitle;

    public SunmiList(Context context) {
        super(context);
        this.initView();
    }

    public SunmiList(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public SunmiList(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        View view = this.getAdapterView();
        this.addView(view);
        this.mTvTitle = (TextView)view.findViewById(R.id.tv_title);
        this.mListView = (ListView)view.findViewById(R.id.list_view);
    }

    private View getAdapterView() {
        switch (Adaptation.proportion) {
            case 1: {
                return View.inflate((Context)this.getContext(), (int)R.layout.list_v1_9_16, null);
            }
            case 2: {
                return View.inflate((Context)this.getContext(), (int)R.layout.list_v1_9_16, null);
            }
            case 3: {
                return View.inflate((Context)this.getContext(), (int)R.layout.list_t1_16_9, null);
            }
            case 4: {
                return View.inflate((Context)this.getContext(), (int)R.layout.list_t1_16_9, null);
            }
        }
        return View.inflate((Context)this.getContext(), (int)R.layout.list_v1_9_16, null);
    }

    public void setTitleText(String title) {
        this.mTvTitle.setText((CharSequence)title);
    }

    public void setListAdapter(List<SunmiListBean> list) {
        this.mListView.setAdapter((ListAdapter)new SunmiListAdapter(this.getContext(), list));
    }

    public void onItemClick(AdapterView.OnItemClickListener listener) {
        this.mListView.setOnItemClickListener(listener);
    }
}

