/*
 * Decompiled with CFR 0.152.
 */
package com.takisoft.fix.support.v7.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.v4.content.res.TypedArrayUtils;
import android.support.v7.preference.PreferenceViewHolder;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.takisoft.fix.support.v7.preference.R;

public class PreferenceCategory
extends android.support.v7.preference.PreferenceCategory {
    private static final int[] CATEGORY_ATTRS = new int[]{R.attr.colorAccent, R.attr.preferenceCategory_marginBottom};
    protected int color;
    protected View itemView;

    public PreferenceCategory(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.PreferenceCategory, defStyleAttr, 0);
        this.color = a.getColor(R.styleable.PreferenceCategory_pref_categoryColor, 0);
        a.recycle();
    }

    public PreferenceCategory(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public PreferenceCategory(Context context, AttributeSet attrs) {
        this(context, attrs, TypedArrayUtils.getAttr((Context)context, (int)R.attr.preferenceCategoryStyle, (int)16842892));
    }

    public PreferenceCategory(Context context) {
        this(context, null);
    }

    private void setTitleVisibility(View itemView, boolean isVisible) {
        RecyclerView.LayoutParams param;
        boolean wasHidden;
        if (itemView == null) {
            return;
        }
        RecyclerView.LayoutParams currentParams = (RecyclerView.LayoutParams)itemView.getLayoutParams();
        boolean bl = wasHidden = itemView.getTag() != null && currentParams.width == 0;
        if (itemView.getTag() == null) {
            param = new RecyclerView.LayoutParams((ViewGroup.MarginLayoutParams)currentParams);
            itemView.setTag((Object)param);
        } else {
            param = (RecyclerView.LayoutParams)itemView.getTag();
        }
        if (isVisible) {
            if (itemView.getVisibility() == 8 || wasHidden) {
                currentParams.width = param.width;
                currentParams.height = param.height;
                currentParams.leftMargin = param.leftMargin;
                currentParams.rightMargin = param.rightMargin;
                currentParams.topMargin = param.topMargin;
                currentParams.bottomMargin = param.bottomMargin;
                itemView.setVisibility(0);
            }
        } else if (itemView.getVisibility() == 0 || !wasHidden) {
            currentParams.width = 0;
            currentParams.height = 0;
            currentParams.leftMargin = 0;
            currentParams.rightMargin = 0;
            currentParams.topMargin = 0;
            currentParams.bottomMargin = 0;
            itemView.setVisibility(8);
        }
    }

    public void setTitle(CharSequence title) {
        super.setTitle(title);
        this.setTitleVisibility(this.itemView, !TextUtils.isEmpty((CharSequence)this.getTitle()));
    }

    public void setColor(@ColorInt int color) {
        this.color = color;
    }

    public void setColorResource(@ColorRes int resId) {
        int color = Build.VERSION.SDK_INT < 23 ? this.getContext().getResources().getColor(resId) : this.getContext().getColor(resId);
        this.setColor(color);
    }

    public void onBindViewHolder(PreferenceViewHolder holder) {
        super.onBindViewHolder(holder);
        this.itemView = holder.itemView;
        TextView titleView = (TextView)holder.findViewById(16908310);
        if (titleView != null) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(CATEGORY_ATTRS);
            if (typedArray.length() > 0 && typedArray.getIndexCount() > 0) {
                int bottomMargin;
                int accentColor = typedArray.getColor(typedArray.getIndex(0), 16728193);
                titleView.setTextColor(this.color == 0 ? accentColor : this.color);
                int marginIdx = typedArray.getIndex(1);
                TypedValue marginValue = typedArray.peekValue(marginIdx);
                if (typedArray.hasValue(marginIdx) && marginValue != null && marginValue.type == 5 && (bottomMargin = typedArray.getDimensionPixelSize(marginIdx, -1)) > -1) {
                    ((ViewGroup.MarginLayoutParams)titleView.getLayoutParams()).bottomMargin = bottomMargin;
                }
            }
            typedArray.recycle();
        }
        boolean isVisible = !TextUtils.isEmpty((CharSequence)this.getTitle());
        this.setTitleVisibility(holder.itemView, isVisible);
    }
}

