/*
 * Decompiled with CFR 0.152.
 */
package anet.channel;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.LruCache;
import anet.channel.AccsSessionManager;
import anet.channel.AwcnConfig;
import anet.channel.Config;
import anet.channel.GlobalAppRuntimeInfo;
import anet.channel.ISessionListener;
import anet.channel.NoAvailStrategyException;
import anet.channel.Session;
import anet.channel.SessionGetCallback;
import anet.channel.SessionInfo;
import anet.channel.SessionRequest;
import anet.channel.d;
import anet.channel.detect.n;
import anet.channel.e;
import anet.channel.entity.ConnType;
import anet.channel.entity.ENV;
import anet.channel.entity.c;
import anet.channel.security.ISecurity;
import anet.channel.status.NetworkStatusHelper;
import anet.channel.strategy.ConnProtocol;
import anet.channel.strategy.IStrategyListener;
import anet.channel.strategy.StrategyCenter;
import anet.channel.strategy.dispatch.AmdcRuntimeInfo;
import anet.channel.strategy.l;
import anet.channel.util.ALog;
import anet.channel.util.AppLifecycle;
import anet.channel.util.HttpUrl;
import anet.channel.util.StringUtils;
import anet.channel.util.Utils;
import anet.channel.util.i;
import java.net.ConnectException;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.android.spdy.SpdyAgent;
import org.android.spdy.SpdySessionKind;
import org.android.spdy.SpdyVersion;

public class SessionCenter {
    public static final String TAG = "awcn.SessionCenter";
    static Map<Config, SessionCenter> a = new HashMap<Config, SessionCenter>();
    private static boolean j = false;
    Context b;
    String c;
    Config d;
    final e e = new e();
    final LruCache<String, SessionRequest> f = new LruCache(32);
    final anet.channel.c g = new anet.channel.c();
    final AccsSessionManager h;
    final a i = new a(null);

    public static synchronized void init(Context context) {
        if (context == null) {
            ALog.e(TAG, "context is null!", null, new Object[0]);
            throw new NullPointerException("init failed. context is null");
        }
        GlobalAppRuntimeInfo.setContext(context.getApplicationContext());
        if (!j) {
            a.put(Config.DEFAULT_CONFIG, new SessionCenter(Config.DEFAULT_CONFIG));
            AppLifecycle.initialize();
            NetworkStatusHelper.startListener(context);
            if (!AwcnConfig.isTbNextLaunch()) {
                StrategyCenter.getInstance().initialize(GlobalAppRuntimeInfo.getContext());
            }
            if (GlobalAppRuntimeInfo.isTargetProcess()) {
                n.a();
                anet.channel.e.a.a();
            }
            j = true;
        }
    }

    @Deprecated
    public static synchronized void init(Context context, String string) {
        SessionCenter.init(context, string, GlobalAppRuntimeInfo.getEnv());
    }

    public static synchronized void init(Context context, String string, ENV eNV) {
        if (context == null) {
            ALog.e(TAG, "context is null!", null, new Object[0]);
            throw new NullPointerException("init failed. context is null");
        }
        Config config = Config.getConfig(string, eNV);
        if (config == null) {
            config = new Config.Builder().setAppkey(string).setEnv(eNV).build();
        }
        SessionCenter.init(context, config);
    }

    public static synchronized void init(Context context, Config config) {
        if (context == null) {
            ALog.e(TAG, "context is null!", null, new Object[0]);
            throw new NullPointerException("init failed. context is null");
        }
        if (config == null) {
            ALog.e(TAG, "paramter config is null!", null, new Object[0]);
            throw new NullPointerException("init failed. config is null");
        }
        SessionCenter.init(context);
        if (!a.containsKey(config)) {
            SessionCenter sessionCenter = new SessionCenter(config);
            a.put(config, sessionCenter);
        }
    }

    private SessionCenter(Config config) {
        this.b = GlobalAppRuntimeInfo.getContext();
        this.d = config;
        this.c = config.getAppkey();
        this.i.a();
        this.h = new AccsSessionManager(this);
        if (!config.getAppkey().equals("[default]")) {
            ISecurity iSecurity = config.getSecurity();
            String string = config.getAppkey();
            AmdcRuntimeInfo.setSign(new d(this, string, iSecurity));
        }
    }

    @Deprecated
    public synchronized void switchEnv(ENV eNV) {
        SessionCenter.switchEnvironment(eNV);
    }

    public static synchronized void switchEnvironment(ENV eNV) {
        try {
            SpdyAgent spdyAgent;
            if (GlobalAppRuntimeInfo.getEnv() != eNV) {
                ALog.i(TAG, "switch env", null, new Object[]{"old", GlobalAppRuntimeInfo.getEnv(), "new", eNV});
                GlobalAppRuntimeInfo.setEnv(eNV);
                StrategyCenter.getInstance().switchEnv();
                spdyAgent = SpdyAgent.getInstance((Context)GlobalAppRuntimeInfo.getContext(), (SpdyVersion)SpdyVersion.SPDY3, (SpdySessionKind)SpdySessionKind.NONE_SESSION);
                spdyAgent.switchAccsServer(eNV == ENV.TEST ? 0 : 1);
            }
            spdyAgent = a.entrySet().iterator();
            while (spdyAgent.hasNext()) {
                SessionCenter sessionCenter = spdyAgent.next().getValue();
                if (sessionCenter.d.getEnv() == eNV) continue;
                ALog.i(TAG, "remove instance", sessionCenter.c, new Object[]{"ENVIRONMENT", sessionCenter.d.getEnv()});
                sessionCenter.h.forceCloseSession(false);
                sessionCenter.i.b();
                spdyAgent.remove();
            }
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "switch env error.", null, throwable, new Object[0]);
        }
    }

    public static synchronized SessionCenter getInstance(String string) {
        Config config = Config.getConfigByTag(string);
        if (config == null) {
            throw new RuntimeException("tag not exist!");
        }
        return SessionCenter.getInstance(config);
    }

    public static synchronized SessionCenter getInstance(Config config) {
        Object object;
        if (config == null) {
            throw new NullPointerException("config is null!");
        }
        if (!j && (object = Utils.getAppContext()) != null) {
            SessionCenter.init(object);
        }
        if ((object = a.get(config)) == null) {
            object = new SessionCenter(config);
            a.put(config, (SessionCenter)object);
        }
        return object;
    }

    @Deprecated
    public static synchronized SessionCenter getInstance() {
        Object object;
        if (!j && (object = Utils.getAppContext()) != null) {
            SessionCenter.init(object);
        }
        object = null;
        for (Map.Entry<Config, SessionCenter> entry : a.entrySet()) {
            object = entry.getValue();
            if (entry.getKey() == Config.DEFAULT_CONFIG) continue;
            return object;
        }
        return object;
    }

    public Session getThrowsException(String string, long l2) throws Exception {
        return this.a(HttpUrl.parse(string), anet.channel.entity.c.c, l2, null);
    }

    @Deprecated
    public Session getThrowsException(String string, ConnType.TypeLevel typeLevel, long l2) throws Exception {
        return this.a(HttpUrl.parse(string), typeLevel == ConnType.TypeLevel.SPDY ? anet.channel.entity.c.a : anet.channel.entity.c.b, l2, null);
    }

    public Session getThrowsException(HttpUrl httpUrl, int n2, long l2) throws Exception {
        return this.a(httpUrl, n2, l2, null);
    }

    @Deprecated
    public Session getThrowsException(HttpUrl httpUrl, ConnType.TypeLevel typeLevel, long l2) throws Exception {
        return this.a(httpUrl, typeLevel == ConnType.TypeLevel.SPDY ? anet.channel.entity.c.a : anet.channel.entity.c.b, l2, null);
    }

    public Session get(String string, long l2) {
        return this.get(HttpUrl.parse(string), anet.channel.entity.c.c, l2);
    }

    @Deprecated
    public Session get(String string, ConnType.TypeLevel typeLevel, long l2) {
        return this.get(HttpUrl.parse(string), typeLevel == ConnType.TypeLevel.SPDY ? anet.channel.entity.c.a : anet.channel.entity.c.b, l2);
    }

    @Deprecated
    public Session get(HttpUrl httpUrl, ConnType.TypeLevel typeLevel, long l2) {
        return this.get(httpUrl, typeLevel == ConnType.TypeLevel.SPDY ? anet.channel.entity.c.a : anet.channel.entity.c.b, l2);
    }

    public Session get(HttpUrl httpUrl, int n2, long l2) {
        Session session = null;
        try {
            session = this.a(httpUrl, n2, l2, null);
        }
        catch (InvalidParameterException invalidParameterException) {
            ALog.e(TAG, "[Get]param url is invalid", this.c, invalidParameterException, "url", httpUrl);
        }
        catch (TimeoutException timeoutException) {
            ALog.e(TAG, "[Get]timeout exception", this.c, timeoutException, "url", httpUrl.urlString());
        }
        catch (ConnectException connectException) {
            ALog.e(TAG, "[Get]connect exception", this.c, "errMsg", connectException.getMessage(), "url", httpUrl.urlString());
        }
        catch (NoAvailStrategyException noAvailStrategyException) {
            ALog.i(TAG, "[Get]" + noAvailStrategyException.getMessage(), this.c, null, "url", httpUrl.urlString());
        }
        catch (Exception exception) {
            ALog.e(TAG, "[Get]" + exception.getMessage(), this.c, null, "url", httpUrl.urlString());
        }
        return session;
    }

    public void asyncGet(HttpUrl httpUrl, int n2, long l2, SessionGetCallback sessionGetCallback) {
        if (sessionGetCallback == null) {
            throw new NullPointerException("cb is null");
        }
        if (l2 <= 0L) {
            throw new InvalidParameterException("timeout must > 0");
        }
        try {
            this.b(httpUrl, n2, l2, sessionGetCallback);
        }
        catch (Exception exception) {
            sessionGetCallback.onSessionGetFail();
        }
    }

    public void registerSessionInfo(SessionInfo sessionInfo) {
        this.g.a(sessionInfo);
        if (sessionInfo.isKeepAlive) {
            this.h.checkAndStartSession();
        }
    }

    public void unregisterSessionInfo(String string) {
        SessionInfo sessionInfo = this.g.a(string);
        if (sessionInfo != null && sessionInfo.isKeepAlive) {
            this.h.checkAndStartSession();
        }
    }

    public void registerAccsSessionListener(ISessionListener iSessionListener) {
        this.h.registerListener(iSessionListener);
    }

    public void unregisterAccsSessionListener(ISessionListener iSessionListener) {
        this.h.unregisterListener(iSessionListener);
    }

    public void registerPublicKey(String string, int n2) {
        this.g.a(string, n2);
    }

    public static void checkAndStartAccsSession() {
        for (SessionCenter sessionCenter : a.values()) {
            sessionCenter.h.checkAndStartSession();
        }
    }

    public void forceRecreateAccsSession() {
        this.h.forceCloseSession(true);
    }

    private SessionRequest a(HttpUrl httpUrl) {
        String string = StrategyCenter.getInstance().getCNameByHost(httpUrl.host());
        String string2 = string == null ? httpUrl.host() : string;
        String string3 = httpUrl.scheme();
        if (!httpUrl.isSchemeLocked()) {
            string3 = StrategyCenter.getInstance().getSchemeByHost(string2, string3);
        }
        String string4 = StringUtils.concatString(string3, "://", string2);
        return this.a(string4);
    }

    protected Session a(HttpUrl httpUrl, int n2, long l2, SessionGetCallback sessionGetCallback) throws Exception {
        if (!j) {
            ALog.e(TAG, "getInternal not inited!", this.c, new Object[0]);
            throw new IllegalStateException("getInternal not inited");
        }
        if (httpUrl == null) {
            throw new InvalidParameterException("httpUrl is null");
        }
        ALog.d(TAG, "getInternal", this.c, "u", httpUrl.urlString(), "sessionType", n2 == anet.channel.entity.c.a ? "LongLink" : "ShortLink", "timeout", l2);
        SessionRequest sessionRequest = this.a(httpUrl);
        Session session = this.e.a(sessionRequest, n2);
        if (session != null) {
            ALog.d(TAG, "get internal hit cache session", this.c, "session", session);
        } else {
            SessionInfo sessionInfo;
            if (this.d == Config.DEFAULT_CONFIG && n2 != anet.channel.entity.c.b) {
                if (sessionGetCallback != null) {
                    sessionGetCallback.onSessionGetFail();
                }
                return null;
            }
            if (GlobalAppRuntimeInfo.isAppBackground() && n2 == anet.channel.entity.c.a && AwcnConfig.isAccsSessionCreateForbiddenInBg() && (sessionInfo = this.g.b(httpUrl.host())) != null && sessionInfo.isAccs) {
                ALog.w(TAG, "app background, forbid to create accs session", this.c, new Object[0]);
                throw new ConnectException("accs session connecting forbidden in background");
            }
            sessionRequest.a(this.b, n2, anet.channel.util.i.a(this.c), sessionGetCallback, l2);
            if (sessionGetCallback == null && l2 > 0L && (n2 == anet.channel.entity.c.c || sessionRequest.b() == n2)) {
                sessionRequest.a(l2);
                session = this.e.a(sessionRequest, n2);
                if (session == null) {
                    throw new ConnectException("session connecting failed or timeout");
                }
            }
        }
        return session;
    }

    protected void b(HttpUrl httpUrl, int n2, long l2, SessionGetCallback sessionGetCallback) throws Exception {
        SessionInfo sessionInfo;
        if (!j) {
            ALog.e(TAG, "getInternal not inited!", this.c, new Object[0]);
            throw new IllegalStateException("getInternal not inited");
        }
        if (httpUrl == null) {
            throw new InvalidParameterException("httpUrl is null");
        }
        if (sessionGetCallback == null) {
            throw new InvalidParameterException("sessionGetCallback is null");
        }
        ALog.d(TAG, "getInternal", this.c, "u", httpUrl.urlString(), "sessionType", n2 == anet.channel.entity.c.a ? "LongLink" : "ShortLink", "timeout", l2);
        SessionRequest sessionRequest = this.a(httpUrl);
        Session session = this.e.a(sessionRequest, n2);
        if (session != null) {
            ALog.d(TAG, "get internal hit cache session", this.c, "session", session);
            sessionGetCallback.onSessionGetSuccess(session);
            return;
        }
        if (this.d == Config.DEFAULT_CONFIG && n2 != anet.channel.entity.c.b) {
            sessionGetCallback.onSessionGetFail();
            return;
        }
        if (GlobalAppRuntimeInfo.isAppBackground() && n2 == anet.channel.entity.c.a && AwcnConfig.isAccsSessionCreateForbiddenInBg() && (sessionInfo = this.g.b(httpUrl.host())) != null && sessionInfo.isAccs) {
            ALog.w(TAG, "app background, forbid to create accs session", this.c, new Object[0]);
            throw new ConnectException("accs session connecting forbidden in background");
        }
        sessionRequest.b(this.b, n2, anet.channel.util.i.a(this.c), sessionGetCallback, l2);
    }

    @Deprecated
    public void enterBackground() {
        AppLifecycle.onBackground();
    }

    @Deprecated
    public void enterForeground() {
        AppLifecycle.onForeground();
    }

    private void a(l.d d2) {
        try {
            l.b[] bArray = d2.b;
            for (int i2 = 0; i2 < bArray.length; ++i2) {
                l.b b2 = bArray[i2];
                if (b2.k) {
                    this.b(b2);
                }
                if (b2.e == null) continue;
                this.a(b2);
            }
        }
        catch (Exception exception) {
            ALog.e(TAG, "checkStrategy failed", this.c, exception, new Object[0]);
        }
    }

    private void a(l.b b2) {
        List<Session> list = this.e.a(this.a(StringUtils.buildKey(b2.c, b2.a)));
        for (Session session : list) {
            if (StringUtils.isStringEqual(session.l, b2.e)) continue;
            ALog.i(TAG, "unit change", session.p, "session unit", session.l, "unit", b2.e);
            session.close(true);
        }
    }

    private void b(l.b b2) {
        ALog.i(TAG, "find effectNow", this.c, "host", b2.a);
        Object[] objectArray = b2.h;
        Object[] objectArray2 = b2.f;
        List<Session> list = this.e.a(this.a(StringUtils.buildKey(b2.c, b2.a)));
        for (Session session : list) {
            int n2;
            if (session.getConnType().isHttpType()) continue;
            boolean bl = false;
            for (n2 = 0; n2 < objectArray2.length; ++n2) {
                if (!session.getIp().equals(objectArray2[n2])) continue;
                bl = true;
                break;
            }
            if (!bl) {
                if (ALog.isPrintLog(2)) {
                    ALog.i(TAG, "ip not match", session.p, "session ip", session.getIp(), "ips", Arrays.toString(objectArray2));
                }
                session.close(true);
                continue;
            }
            n2 = 0;
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (session.getPort() != objectArray[i2].a || !session.getConnType().equals(ConnType.valueOf(ConnProtocol.valueOf(objectArray[i2])))) continue;
                n2 = 1;
                break;
            }
            if (n2 != 0) continue;
            if (ALog.isPrintLog(2)) {
                ALog.i(TAG, "aisle not match", session.p, "port", session.getPort(), "connType", session.getConnType(), "aisle", Arrays.toString(objectArray));
            }
            session.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionRequest a(String string) {
        SessionRequest sessionRequest;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        LruCache<String, SessionRequest> lruCache = this.f;
        synchronized (lruCache) {
            sessionRequest = (SessionRequest)this.f.get((Object)string);
            if (sessionRequest == null) {
                sessionRequest = new SessionRequest(string, this);
                this.f.put((Object)string, (Object)sessionRequest);
            }
        }
        return sessionRequest;
    }

    private class a
    implements NetworkStatusHelper.INetworkStatusChangeListener,
    IStrategyListener,
    AppLifecycle.AppLifecycleListener {
        boolean a = false;

        private a() {
        }

        void a() {
            AppLifecycle.registerLifecycleListener(this);
            NetworkStatusHelper.addStatusChangeListener(this);
            StrategyCenter.getInstance().registerListener(this);
        }

        void b() {
            StrategyCenter.getInstance().unregisterListener(this);
            AppLifecycle.unregisterLifecycleListener(this);
            NetworkStatusHelper.removeStatusChangeListener(this);
        }

        @Override
        public void onNetworkStatusChanged(NetworkStatusHelper.NetworkStatus networkStatus) {
            ALog.e(SessionCenter.TAG, "onNetworkStatusChanged.", SessionCenter.this.c, new Object[]{"networkStatus", networkStatus});
            List<SessionRequest> list = SessionCenter.this.e.a();
            if (!list.isEmpty()) {
                for (SessionRequest sessionRequest : list) {
                    ALog.d(SessionCenter.TAG, "network change, try recreate session", SessionCenter.this.c, new Object[0]);
                    sessionRequest.a((String)null);
                }
            }
            SessionCenter.this.h.checkAndStartSession();
        }

        @Override
        public void onStrategyUpdated(l.d d2) {
            SessionCenter.this.a(d2);
            SessionCenter.this.h.checkAndStartSession();
        }

        @Override
        public void forground() {
            ALog.i(SessionCenter.TAG, "[forground]", SessionCenter.this.c, new Object[0]);
            if (SessionCenter.this.b == null) {
                return;
            }
            if (this.a) {
                return;
            }
            this.a = true;
            if (!j) {
                ALog.e(SessionCenter.TAG, "forground not inited!", SessionCenter.this.c, new Object[0]);
                return;
            }
            try {
                try {
                    if (AppLifecycle.lastEnterBackgroundTime != 0L && System.currentTimeMillis() - AppLifecycle.lastEnterBackgroundTime > 60000L) {
                        SessionCenter.this.h.forceCloseSession(true);
                    } else {
                        SessionCenter.this.h.checkAndStartSession();
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    this.a = false;
                }
            }
            catch (Exception exception) {}
        }

        @Override
        public void background() {
            ALog.i(SessionCenter.TAG, "[background]", SessionCenter.this.c, new Object[0]);
            if (!j) {
                ALog.e(SessionCenter.TAG, "background not inited!", SessionCenter.this.c, new Object[0]);
                return;
            }
            try {
                StrategyCenter.getInstance().saveData();
                if (AwcnConfig.isAccsSessionCreateForbiddenInBg() && "OPPO".equalsIgnoreCase(Build.BRAND)) {
                    ALog.i(SessionCenter.TAG, "close session for OPPO", SessionCenter.this.c, new Object[0]);
                    SessionCenter.this.h.forceCloseSession(false);
                }
            }
            catch (Exception exception) {}
        }

        /* synthetic */ a(d d2) {
            this();
        }
    }
}

