/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.strategy;

import android.text.TextUtils;
import anet.channel.AwcnConfig;
import anet.channel.strategy.ConnEvent;
import anet.channel.strategy.IConnStrategy;
import anet.channel.strategy.StrategyCenter;
import anet.channel.strategy.dispatch.HttpDispatcher;
import java.util.ArrayList;
import java.util.List;

public class HttpDnsAdapter {
    public static void setHosts(ArrayList<String> arrayList) {
        HttpDispatcher.getInstance().addHosts(arrayList);
    }

    public static HttpDnsOrigin getOriginByHttpDns(String string) {
        List<IConnStrategy> list = StrategyCenter.getInstance().getConnStrategyListByHost(string);
        if (list.isEmpty()) {
            return null;
        }
        IConnStrategy iConnStrategy = list.get(0);
        return new HttpDnsOrigin(iConnStrategy);
    }

    public static ArrayList<HttpDnsOrigin> getOriginsByHttpDns(String string) {
        return HttpDnsAdapter.getOriginsByHttpDns(string, true);
    }

    public static ArrayList<HttpDnsOrigin> getOriginsByHttpDns(String string, boolean bl) {
        List<IConnStrategy> list = StrategyCenter.getInstance().getConnStrategyListByHost(string);
        if (list.isEmpty()) {
            return null;
        }
        ArrayList<HttpDnsOrigin> arrayList = new ArrayList<HttpDnsOrigin>(list.size());
        for (IConnStrategy iConnStrategy : list) {
            if (!bl && iConnStrategy.getIpSource() == 1) continue;
            arrayList.add(new HttpDnsOrigin(iConnStrategy));
        }
        return arrayList;
    }

    public static String getIpByHttpDns(String string) {
        List<IConnStrategy> list = StrategyCenter.getInstance().getConnStrategyListByHost(string);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0).getIp();
    }

    public static void notifyConnEvent(String string, HttpDnsOrigin httpDnsOrigin, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string) || httpDnsOrigin == null) {
            return;
        }
        if (!AwcnConfig.isAllowHttpDnsNotify(string)) {
            return;
        }
        ConnEvent connEvent = new ConnEvent();
        connEvent.isSuccess = bl;
        StrategyCenter.getInstance().notifyConnEvent(string, httpDnsOrigin.connStrategy, connEvent);
    }

    public static final class HttpDnsOrigin {
        final IConnStrategy connStrategy;

        HttpDnsOrigin(IConnStrategy iConnStrategy) {
            this.connStrategy = iConnStrategy;
        }

        public String getOriginIP() {
            return this.connStrategy.getIp();
        }

        public int getOriginPort() {
            return this.connStrategy.getPort();
        }

        public String getOriginProtocol() {
            return this.connStrategy.getProtocol().protocol;
        }

        public boolean canWithSPDY() {
            String string = this.connStrategy.getProtocol().protocol;
            return !string.equalsIgnoreCase("http") && !string.equalsIgnoreCase("https");
        }

        public String toString() {
            return this.connStrategy.toString();
        }
    }
}

