/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.util;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import anet.channel.AwcnConfig;
import anet.channel.GlobalAppRuntimeInfo;
import anet.channel.thread.ThreadPoolExecutorFactory;
import anet.channel.util.ALog;
import java.util.concurrent.CopyOnWriteArraySet;

public class AppLifecycle {
    private static final String TAG = "awcn.AppLifeCycle";
    private static CopyOnWriteArraySet<AppLifecycleListener> listeners = new CopyOnWriteArraySet();
    public static volatile long lastEnterBackgroundTime = 0L;
    public static volatile boolean isGoingForeground = false;
    private static Application.ActivityLifecycleCallbacks mActivityLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

        public void onActivityCreated(Activity activity, Bundle bundle) {
            if (GlobalAppRuntimeInfo.isAppBackground()) {
                isGoingForeground = true;
            }
        }

        public void onActivityStarted(Activity activity) {
            if (GlobalAppRuntimeInfo.isAppBackground()) {
                isGoingForeground = true;
            }
        }

        public void onActivityResumed(Activity activity) {
            AppLifecycle.onForeground();
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
        }
    };
    private static ComponentCallbacks2 mComponentCallbacks2 = new ComponentCallbacks2(){

        public void onTrimMemory(int n2) {
            ALog.i(AppLifecycle.TAG, "onTrimMemory", null, "level", n2);
            if (n2 == 20) {
                AppLifecycle.onBackground();
            }
        }

        public void onConfigurationChanged(Configuration configuration) {
        }

        public void onLowMemory() {
        }
    };

    private AppLifecycle() {
    }

    public static void initialize() {
        if (Build.VERSION.SDK_INT >= 14 && AwcnConfig.isAppLifeCycleListenerEnable()) {
            ((Application)GlobalAppRuntimeInfo.getContext().getApplicationContext()).registerActivityLifecycleCallbacks(mActivityLifecycleCallbacks);
            GlobalAppRuntimeInfo.getContext().registerComponentCallbacks((ComponentCallbacks)mComponentCallbacks2);
        }
    }

    public static void registerLifecycleListener(AppLifecycleListener appLifecycleListener) {
        if (appLifecycleListener != null) {
            listeners.add(appLifecycleListener);
        }
    }

    public static void unregisterLifecycleListener(AppLifecycleListener appLifecycleListener) {
        listeners.remove(appLifecycleListener);
    }

    public static void onForeground() {
        if (GlobalAppRuntimeInfo.isAppBackground()) {
            GlobalAppRuntimeInfo.setBackground(false);
            isGoingForeground = false;
            AppLifecycle.notifyListener(true);
        }
    }

    public static void onBackground() {
        if (!GlobalAppRuntimeInfo.isAppBackground()) {
            GlobalAppRuntimeInfo.setBackground(true);
            lastEnterBackgroundTime = System.currentTimeMillis();
            AppLifecycle.notifyListener(false);
        }
    }

    private static void notifyListener(final boolean bl) {
        ALog.i(TAG, "notifyListener", null, "foreground", bl);
        ThreadPoolExecutorFactory.submitScheduledTask(new Runnable(){

            @Override
            public void run() {
                for (AppLifecycleListener appLifecycleListener : listeners) {
                    try {
                        if (bl) {
                            appLifecycleListener.forground();
                            continue;
                        }
                        appLifecycleListener.background();
                    }
                    catch (Exception exception) {
                        ALog.e(AppLifecycle.TAG, "notifyListener exception.", null, exception, new Object[0]);
                    }
                }
            }
        });
    }

    public static interface AppLifecycleListener {
        public void forground();

        public void background();
    }
}

