/*
 * Decompiled with CFR 0.152.
 */
package anetwork.channel.aidl.adapter;

import android.os.Handler;
import android.os.RemoteException;
import anet.channel.util.ALog;
import anetwork.channel.NetworkCallBack;
import anetwork.channel.NetworkListener;
import anetwork.channel.aidl.DefaultFinishEvent;
import anetwork.channel.aidl.DefaultProgressEvent;
import anetwork.channel.aidl.ParcelableHeader;
import anetwork.channel.aidl.ParcelableInputStream;
import anetwork.channel.aidl.ParcelableNetworkListener;
import anetwork.channel.aidl.adapter.c;

public class ParcelableNetworkListenerWrapper
extends ParcelableNetworkListener.Stub {
    private static final String TAG = "anet.ParcelableNetworkListenerWrapper";
    private NetworkListener listener;
    private Handler handler;
    private Object mContext;
    private byte state = 0;

    public NetworkListener getListener() {
        return this.listener;
    }

    public ParcelableNetworkListenerWrapper(NetworkListener networkListener, Handler handler, Object object) {
        this.listener = networkListener;
        if (networkListener != null) {
            if (NetworkCallBack.FinishListener.class.isAssignableFrom(networkListener.getClass())) {
                this.state = (byte)(this.state | 1);
            }
            if (NetworkCallBack.ProgressListener.class.isAssignableFrom(networkListener.getClass())) {
                this.state = (byte)(this.state | 2);
            }
            if (NetworkCallBack.ResponseCodeListener.class.isAssignableFrom(networkListener.getClass())) {
                this.state = (byte)(this.state | 4);
            }
            if (NetworkCallBack.InputStreamListener.class.isAssignableFrom(networkListener.getClass())) {
                this.state = (byte)(this.state | 8);
            }
        }
        this.handler = handler;
        this.mContext = object;
    }

    private void dispatch(byte by, Object object) {
        if (this.handler == null) {
            this.dispatchCallback(by, object);
        } else {
            this.handler.post((Runnable)new c(this, by, object));
        }
    }

    private void dispatchCallback(byte by, Object object) {
        try {
            if (by == 4) {
                ParcelableHeader parcelableHeader = (ParcelableHeader)object;
                ((NetworkCallBack.ResponseCodeListener)this.listener).onResponseCode(parcelableHeader.getResponseCode(), parcelableHeader.getHeader(), this.mContext);
                if (ALog.isPrintLog(1)) {
                    ALog.d(TAG, "[onResponseCode]" + parcelableHeader, null, new Object[0]);
                }
            } else if (by == 2) {
                DefaultProgressEvent defaultProgressEvent = (DefaultProgressEvent)object;
                if (defaultProgressEvent != null) {
                    defaultProgressEvent.setContext(this.mContext);
                }
                ((NetworkCallBack.ProgressListener)this.listener).onDataReceived(defaultProgressEvent, this.mContext);
                if (ALog.isPrintLog(1)) {
                    ALog.d(TAG, "[onDataReceived]" + defaultProgressEvent, null, new Object[0]);
                }
            } else if (by == 1) {
                DefaultFinishEvent defaultFinishEvent = (DefaultFinishEvent)object;
                if (defaultFinishEvent != null) {
                    defaultFinishEvent.setContext(this.mContext);
                }
                ((NetworkCallBack.FinishListener)this.listener).onFinished(defaultFinishEvent, this.mContext);
                if (ALog.isPrintLog(1)) {
                    ALog.d(TAG, "[onFinished]" + defaultFinishEvent, null, new Object[0]);
                }
            } else if (by == 8) {
                ParcelableInputStream parcelableInputStream = (ParcelableInputStream)object;
                ((NetworkCallBack.InputStreamListener)this.listener).onInputStreamGet(parcelableInputStream, this.mContext);
                if (ALog.isPrintLog(1)) {
                    ALog.d(TAG, "[onInputStreamReceived]", null, new Object[0]);
                }
            }
        }
        catch (Exception exception) {
            ALog.e(TAG, "dispatchCallback error", null, new Object[0]);
        }
    }

    @Override
    public void onDataReceived(DefaultProgressEvent defaultProgressEvent) throws RemoteException {
        if ((this.state & 2) != 0) {
            this.dispatch((byte)2, defaultProgressEvent);
        }
    }

    @Override
    public void onFinished(DefaultFinishEvent defaultFinishEvent) throws RemoteException {
        if ((this.state & 1) != 0) {
            this.dispatch((byte)1, defaultFinishEvent);
        }
        this.listener = null;
        this.mContext = null;
        this.handler = null;
    }

    @Override
    public boolean onResponseCode(int n2, ParcelableHeader parcelableHeader) throws RemoteException {
        if ((this.state & 4) != 0) {
            this.dispatch((byte)4, parcelableHeader);
        }
        return false;
    }

    @Override
    public void onInputStreamGet(ParcelableInputStream parcelableInputStream) throws RemoteException {
        if ((this.state & 8) != 0) {
            this.dispatch((byte)8, parcelableInputStream);
        }
    }

    @Override
    public byte getListenerState() throws RemoteException {
        return this.state;
    }

    static /* synthetic */ void access$000(ParcelableNetworkListenerWrapper parcelableNetworkListenerWrapper, byte by, Object object) {
        parcelableNetworkListenerWrapper.dispatchCallback(by, object);
    }
}

