/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.rs;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import com.taosdata.jdbc.AbstractResultSet;
import com.taosdata.jdbc.TSDBConstants;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.enums.TimestampFormat;
import com.taosdata.jdbc.enums.TimestampPrecision;
import com.taosdata.jdbc.rs.RestfulResultSetMetaData;
import com.taosdata.jdbc.utils.Utils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class RestfulResultSet
extends AbstractResultSet
implements ResultSet {
    private final Statement statement;
    private final List<List<Object>> resultSet = new ArrayList<List<Object>>();
    private final List<String> columnNames = new ArrayList<String>();
    private final List<Field> columns = new ArrayList<Field>();
    private final RestfulResultSetMetaData metaData;
    private volatile boolean isClosed;
    private int pos = -1;

    public RestfulResultSet(String database, Statement statement, JSONObject resultJson) throws SQLException {
        this.statement = statement;
        JSONArray head = resultJson.getJSONArray("head");
        JSONArray columnMeta = resultJson.getJSONArray("column_meta");
        JSONArray data = resultJson.getJSONArray("data");
        Integer rows = resultJson.getInteger("rows");
        if (columnMeta != null) {
            this.parseColumnMeta_new(columnMeta);
        } else {
            this.parseColumnMeta_old(head, data, rows);
        }
        this.metaData = new RestfulResultSetMetaData(database, this.columns, this);
        if (data == null || data.isEmpty()) {
            return;
        }
        for (int rowIndex = 0; rowIndex < data.size(); ++rowIndex) {
            ArrayList<Object> row = new ArrayList<Object>();
            JSONArray jsonRow = data.getJSONArray(rowIndex);
            for (int colIndex = 0; colIndex < this.metaData.getColumnCount(); ++colIndex) {
                row.add(this.parseColumnData(jsonRow, colIndex, this.columns.get((int)colIndex).taos_type));
            }
            this.resultSet.add(row);
        }
    }

    private void parseColumnMeta_new(JSONArray columnMeta) throws SQLException {
        this.columnNames.clear();
        this.columns.clear();
        for (int colIndex = 0; colIndex < columnMeta.size(); ++colIndex) {
            JSONArray col = columnMeta.getJSONArray(colIndex);
            String col_name = col.getString(0);
            int taos_type = col.getInteger(1);
            int col_type = TSDBConstants.taosType2JdbcType(taos_type);
            int col_length = col.getInteger(2);
            this.columnNames.add(col_name);
            this.columns.add(new Field(col_name, col_type, col_length, "", taos_type));
        }
    }

    private void parseColumnMeta_old(JSONArray head, JSONArray data, int rows) {
        this.columnNames.clear();
        this.columns.clear();
        for (int colIndex = 0; colIndex < head.size(); ++colIndex) {
            String col_name = head.getString(colIndex);
            this.columnNames.add(col_name);
            int col_type = 0;
            int col_length = 0;
            int taos_type = 0;
            JSONArray row0Json = data.getJSONArray(0);
            if (colIndex < row0Json.size()) {
                Object value = row0Json.get(colIndex);
                if (value instanceof Boolean) {
                    col_type = 16;
                    col_length = 1;
                    taos_type = 1;
                }
                if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
                    col_type = -5;
                    col_length = 8;
                    taos_type = 5;
                }
                if (value instanceof Float || value instanceof Double || value instanceof BigDecimal) {
                    col_type = 8;
                    col_length = 8;
                    taos_type = 7;
                }
                if (value instanceof String) {
                    col_type = -15;
                    col_length = ((String)value).length();
                    taos_type = 10;
                }
            }
            this.columns.add(new Field(col_name, col_type, col_length, "", taos_type));
        }
    }

    private Object parseColumnData(JSONArray row, int colIndex, int taosType) throws SQLException {
        switch (taosType) {
            case 0: {
                return null;
            }
            case 1: {
                return row.getBoolean(colIndex);
            }
            case 2: {
                return row.getByte(colIndex);
            }
            case 3: {
                return row.getShort(colIndex);
            }
            case 4: {
                return row.getInteger(colIndex);
            }
            case 5: {
                return row.getLong(colIndex);
            }
            case 6: {
                return row.getFloat(colIndex);
            }
            case 7: {
                return row.getDouble(colIndex);
            }
            case 9: {
                return this.parseTimestampColumnData(row, colIndex);
            }
            case 8: {
                return row.getString(colIndex) == null ? null : row.getString(colIndex).getBytes();
            }
            case 10: {
                return row.getString(colIndex) == null ? null : row.getString(colIndex);
            }
        }
        return row.get(colIndex);
    }

    private Timestamp parseTimestampColumnData(JSONArray row, int colIndex) throws SQLException {
        if (row.get(colIndex) == null) {
            return null;
        }
        String tsFormatUpperCase = this.statement.getConnection().getClientInfo("timestampFormat").toUpperCase();
        TimestampFormat timestampFormat = TimestampFormat.valueOf(tsFormatUpperCase);
        switch (timestampFormat) {
            case TIMESTAMP: {
                Long value = row.getLong(colIndex);
                if (value < 10000000000000L) {
                    return new Timestamp(value);
                }
                long epochSec = value / 1000000L;
                long nanoAdjustment = value % 1000000L * 1000L;
                return Timestamp.from(Instant.ofEpochSecond(epochSec, nanoAdjustment));
            }
            case UTC: {
                String value = row.getString(colIndex);
                long epochSec = Timestamp.valueOf(value.substring(0, 19).replace("T", " ")).getTime() / 1000L;
                int fractionalSec = Integer.parseInt(value.substring(20, value.length() - 5));
                long nanoAdjustment = value.length() > 31 ? (long)fractionalSec : (value.length() > 28 ? (long)fractionalSec * 1000L : (long)fractionalSec * 1000000L);
                ZoneOffset zoneOffset = ZoneOffset.of(value.substring(value.length() - 5));
                Instant instant = Instant.ofEpochSecond(epochSec, nanoAdjustment).atOffset(zoneOffset).toInstant();
                return Timestamp.from(instant);
            }
        }
        String value = row.getString(colIndex);
        TimestampPrecision precision = Utils.guessTimestampPrecision(value);
        if (precision == TimestampPrecision.MS) {
            return row.getTimestamp(colIndex);
        }
        if (precision == TimestampPrecision.US) {
            long epochSec = Timestamp.valueOf(value.substring(0, 19)).getTime() / 1000L;
            long nanoAdjustment = (long)Integer.parseInt(value.substring(20)) * 1000L;
            return Timestamp.from(Instant.ofEpochSecond(epochSec, nanoAdjustment));
        }
        if (precision == TimestampPrecision.NS) {
            long epochSec = Timestamp.valueOf(value.substring(0, 19)).getTime() / 1000L;
            long nanoAdjustment = Integer.parseInt(value.substring(20));
            return Timestamp.from(Instant.ofEpochSecond(epochSec, nanoAdjustment));
        }
        throw TSDBError.createSQLException(8982);
    }

    @Override
    public boolean next() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        ++this.pos;
        return this.pos <= this.resultSet.size() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        Class<RestfulResultSet> clazz = RestfulResultSet.class;
        synchronized (RestfulResultSet.class) {
            this.isClosed = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        boolean bl = this.wasNull = value == null;
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return new String((byte[])value);
        }
        return value.toString();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        boolean bl = this.wasNull = value == null;
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.parseBoolean(value.toString());
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        boolean bl = this.wasNull = value == null;
        if (value == null) {
            return 0;
        }
        long valueAsLong = Long.parseLong(value.toString());
        if (valueAsLong == -128L) {
            return 0;
        }
        if (valueAsLong < -128L || valueAsLong > 127L) {
            this.throwRangeException(value.toString(), columnIndex, -6);
        }
        return (byte)valueAsLong;
    }

    private void throwRangeException(String valueAsString, int columnIndex, int jdbcType) throws SQLException {
        throw TSDBError.createSQLException(8980, "'" + valueAsString + "' in column '" + columnIndex + "' is outside valid range for the jdbcType " + TSDBConstants.jdbcType2TaosTypeName(jdbcType));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        boolean bl = this.wasNull = value == null;
        if (value == null) {
            return 0;
        }
        long valueAsLong = Long.parseLong(value.toString());
        if (valueAsLong == -32768L) {
            return 0;
        }
        if (valueAsLong < -32768L || valueAsLong > 32767L) {
            this.throwRangeException(value.toString(), columnIndex, 5);
        }
        return (short)valueAsLong;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        boolean bl = this.wasNull = value == null;
        if (value == null) {
            return 0;
        }
        long valueAsLong = Long.parseLong(value.toString());
        if (valueAsLong == Integer.MIN_VALUE) {
            return 0;
        }
        if (valueAsLong < Integer.MIN_VALUE || valueAsLong > Integer.MAX_VALUE) {
            this.throwRangeException(value.toString(), columnIndex, 4);
        }
        return (int)valueAsLong;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        boolean bl = this.wasNull = value == null;
        if (value == null) {
            return 0L;
        }
        if (value instanceof Timestamp) {
            return ((Timestamp)value).getTime();
        }
        long valueAsLong = 0L;
        try {
            valueAsLong = Long.parseLong(value.toString());
            if (valueAsLong == Long.MIN_VALUE) {
                return 0L;
            }
        }
        catch (NumberFormatException e) {
            this.throwRangeException(value.toString(), columnIndex, -5);
        }
        return valueAsLong;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        boolean bl = this.wasNull = value == null;
        if (value == null) {
            return 0.0f;
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof Double) {
            return new Float((Double)value).floatValue();
        }
        return Float.parseFloat(value.toString());
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        boolean bl = this.wasNull = value == null;
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Double || value instanceof Float) {
            return (Double)value;
        }
        return Double.parseDouble(value.toString());
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        boolean bl = this.wasNull = value == null;
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof String) {
            return ((String)value).getBytes();
        }
        if (value instanceof Long) {
            return Longs.toByteArray((long)((Long)value));
        }
        if (value instanceof Integer) {
            return Ints.toByteArray((int)((Integer)value));
        }
        if (value instanceof Short) {
            return Shorts.toByteArray((short)((Short)value));
        }
        if (value instanceof Byte) {
            return new byte[]{(Byte)value};
        }
        if (value instanceof Timestamp) {
            return Utils.formatTimestamp((Timestamp)value).getBytes();
        }
        return value.toString().getBytes();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        boolean bl = this.wasNull = value == null;
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return new Date(((Timestamp)value).getTime());
        }
        return Utils.parseDate(value.toString());
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        boolean bl = this.wasNull = value == null;
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return new Time(((Timestamp)value).getTime());
        }
        Time time = null;
        try {
            time = Utils.parseTime(value.toString());
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
        return time;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Timestamp ret;
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        boolean bl = this.wasNull = value == null;
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof Long) {
            if (10000000000000L > (Long)value) {
                return Timestamp.from(Instant.ofEpochMilli((Long)value));
            }
            long epochSec = (Long)value / 1000000L;
            long nanoAdjustment = (Long)value % 1000000L * 1000L;
            return Timestamp.from(Instant.ofEpochSecond(epochSec, nanoAdjustment));
        }
        try {
            ret = Utils.parseTimestamp(value.toString());
        }
        catch (Exception e) {
            ret = null;
            this.wasNull = true;
        }
        return ret;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.metaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        this.wasNull = value == null;
        return value;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        int columnIndex = this.columnNames.indexOf(columnLabel);
        if (columnIndex == -1) {
            throw new SQLException("cannot find Column in resultSet");
        }
        return columnIndex + 1;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        BigDecimal ret;
        this.checkAvailability(columnIndex, this.resultSet.get(this.pos).size());
        Object value = this.resultSet.get(this.pos).get(columnIndex - 1);
        boolean bl = this.wasNull = value == null;
        if (value == null) {
            return null;
        }
        if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
            return new BigDecimal(Long.parseLong(value.toString()));
        }
        if (value instanceof Double || value instanceof Float) {
            return BigDecimal.valueOf(Double.parseDouble(value.toString()));
        }
        if (value instanceof Timestamp) {
            return new BigDecimal(((Timestamp)value).getTime());
        }
        try {
            ret = new BigDecimal(value.toString());
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.pos == -1 && this.resultSet.size() != 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.pos >= this.resultSet.size() && this.resultSet.size() != 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.pos == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        if (this.resultSet.size() == 0) {
            return false;
        }
        return this.pos == this.resultSet.size() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        RestfulResultSet restfulResultSet = this;
        synchronized (restfulResultSet) {
            if (this.resultSet.size() > 0) {
                this.pos = -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        RestfulResultSet restfulResultSet = this;
        synchronized (restfulResultSet) {
            if (this.resultSet.size() > 0) {
                this.pos = this.resultSet.size();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean first() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        if (this.resultSet.size() == 0) {
            return false;
        }
        RestfulResultSet restfulResultSet = this;
        synchronized (restfulResultSet) {
            this.pos = 0;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean last() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        if (this.resultSet.size() == 0) {
            return false;
        }
        RestfulResultSet restfulResultSet = this;
        synchronized (restfulResultSet) {
            this.pos = this.resultSet.size() - 1;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRow() throws SQLException {
        int row;
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        RestfulResultSet restfulResultSet = this;
        synchronized (restfulResultSet) {
            if (this.pos < 0 || this.pos >= this.resultSet.size()) {
                return 0;
            }
            row = this.pos + 1;
        }
        return row;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.statement;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    public static class Field {
        String name;
        int type;
        int length;
        String note;
        int taos_type;

        public Field(String name, int type, int length, String note, int taos_type) {
            this.name = name;
            this.type = type;
            this.length = length;
            this.note = note;
            this.taos_type = taos_type;
        }
    }
}

