/*
 * Decompiled with CFR 0.152.
 */
package com.tbuonomo.viewpagerdotsindicator;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.drawable.GradientDrawable;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.tbuonomo.viewpagerdotsindicator.R;
import java.util.ArrayList;
import java.util.List;

public class DotsIndicator
extends LinearLayout {
    private static final int DEFAULT_POINT_COLOR = -16711681;
    public static final float DEFAULT_WIDTH_FACTOR = 2.5f;
    private List<ImageView> dots;
    private ViewPager viewPager;
    private float dotsSize;
    private float dotsCornerRadius;
    private float dotsSpacing;
    private int currentPage;
    private float dotsWidthFactor;
    private int dotsColor;
    private boolean dotsClickable;
    private ViewPager.OnPageChangeListener pageChangedListener;

    public DotsIndicator(Context context) {
        super(context);
        this.init(context, null);
    }

    public DotsIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public DotsIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.dots = new ArrayList<ImageView>();
        this.setOrientation(0);
        this.dotsSize = this.dpToPx(16);
        this.dotsSpacing = this.dpToPx(4);
        this.dotsCornerRadius = this.dotsSize / 2.0f;
        this.dotsWidthFactor = 2.5f;
        this.dotsColor = -16711681;
        this.dotsClickable = true;
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.DotsIndicator);
            this.dotsColor = a.getColor(R.styleable.DotsIndicator_dotsColor, -16711681);
            this.setUpCircleColors(this.dotsColor);
            this.dotsWidthFactor = a.getFloat(R.styleable.DotsIndicator_dotsWidthFactor, 2.5f);
            if (this.dotsWidthFactor < 1.0f) {
                this.dotsWidthFactor = 2.5f;
            }
            this.dotsSize = a.getDimension(R.styleable.DotsIndicator_dotsSize, this.dotsSize);
            this.dotsCornerRadius = (int)a.getDimension(R.styleable.DotsIndicator_dotsCornerRadius, this.dotsSize / 2.0f);
            this.dotsSpacing = a.getDimension(R.styleable.DotsIndicator_dotsSpacing, this.dotsSpacing);
            a.recycle();
        } else {
            this.setUpCircleColors(-16711681);
        }
        if (this.isInEditMode()) {
            this.addDots(5);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.refreshDots();
    }

    private void refreshDots() {
        if (this.viewPager != null && this.viewPager.getAdapter() != null) {
            if (this.dots.size() < this.viewPager.getAdapter().getCount()) {
                this.addDots(this.viewPager.getAdapter().getCount() - this.dots.size());
            } else if (this.dots.size() > this.viewPager.getAdapter().getCount()) {
                this.removeDots(this.dots.size() - this.viewPager.getAdapter().getCount());
            }
            this.setUpDotsAnimators();
        } else {
            Log.e((String)DotsIndicator.class.getSimpleName(), (String)"You have to set an adapter to the view pager before !");
        }
    }

    private void addDots(int count) {
        int i = 0;
        while (i < count) {
            View dot = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.dot_layout, (ViewGroup)this, false);
            ImageView imageView = (ImageView)dot.findViewById(R.id.dot);
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)imageView.getLayoutParams();
            params.width = params.height = (int)this.dotsSize;
            params.setMargins((int)this.dotsSpacing, 0, (int)this.dotsSpacing, 0);
            ((GradientDrawable)imageView.getBackground()).setCornerRadius(this.dotsCornerRadius);
            ((GradientDrawable)imageView.getBackground()).setColor(this.dotsColor);
            final int finalI = i++;
            dot.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (DotsIndicator.this.dotsClickable && DotsIndicator.this.viewPager != null && DotsIndicator.this.viewPager.getAdapter() != null && finalI < DotsIndicator.this.viewPager.getAdapter().getCount()) {
                        DotsIndicator.this.viewPager.setCurrentItem(finalI, true);
                    }
                }
            });
            this.dots.add(imageView);
            this.addView(dot);
        }
    }

    private void removeDots(int count) {
        for (int i = 0; i < count; ++i) {
            this.removeViewAt(this.getChildCount() - 1);
            this.dots.remove(this.dots.size() - 1);
        }
    }

    private void setUpDotsAnimators() {
        if (this.viewPager != null && this.viewPager.getAdapter() != null && this.viewPager.getAdapter().getCount() > 0) {
            RelativeLayout.LayoutParams params;
            View dot;
            if (this.currentPage < this.dots.size() && (dot = (View)this.dots.get(this.currentPage)) != null) {
                params = (RelativeLayout.LayoutParams)dot.getLayoutParams();
                params.width = (int)this.dotsSize;
                dot.setLayoutParams((ViewGroup.LayoutParams)params);
            }
            this.currentPage = this.viewPager.getCurrentItem();
            if (this.currentPage >= this.dots.size()) {
                this.currentPage = this.dots.size() - 1;
                this.viewPager.setCurrentItem(this.currentPage, false);
            }
            if ((dot = (View)this.dots.get(this.currentPage)) != null) {
                params = (RelativeLayout.LayoutParams)dot.getLayoutParams();
                params.width = (int)(this.dotsSize * this.dotsWidthFactor);
                dot.setLayoutParams((ViewGroup.LayoutParams)params);
            }
            if (this.pageChangedListener != null) {
                this.viewPager.removeOnPageChangeListener(this.pageChangedListener);
            }
            this.setUpOnPageChangedListener();
            this.viewPager.addOnPageChangeListener(this.pageChangedListener);
        }
    }

    private void setUpOnPageChangedListener() {
        this.pageChangedListener = new ViewPager.OnPageChangeListener(){
            private int lastPage;

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                if (position != DotsIndicator.this.currentPage && positionOffset == 0.0f || DotsIndicator.this.currentPage < position) {
                    this.setDotWidth((ImageView)DotsIndicator.this.dots.get(DotsIndicator.this.currentPage), (int)DotsIndicator.this.dotsSize);
                    DotsIndicator.this.currentPage = position;
                }
                if (Math.abs(DotsIndicator.this.currentPage - position) > 1) {
                    this.setDotWidth((ImageView)DotsIndicator.this.dots.get(DotsIndicator.this.currentPage), (int)DotsIndicator.this.dotsSize);
                    DotsIndicator.this.currentPage = this.lastPage;
                }
                ImageView dot = (ImageView)DotsIndicator.this.dots.get(DotsIndicator.this.currentPage);
                ImageView nextDot = null;
                if (DotsIndicator.this.currentPage == position && DotsIndicator.this.currentPage + 1 < DotsIndicator.this.dots.size()) {
                    nextDot = (ImageView)DotsIndicator.this.dots.get(DotsIndicator.this.currentPage + 1);
                } else if (DotsIndicator.this.currentPage > position) {
                    nextDot = dot;
                    dot = (ImageView)DotsIndicator.this.dots.get(DotsIndicator.this.currentPage - 1);
                }
                int dotWidth = (int)(DotsIndicator.this.dotsSize + DotsIndicator.this.dotsSize * (DotsIndicator.this.dotsWidthFactor - 1.0f) * (1.0f - positionOffset));
                this.setDotWidth(dot, dotWidth);
                if (nextDot != null) {
                    int nextDotWidth = (int)(DotsIndicator.this.dotsSize + DotsIndicator.this.dotsSize * (DotsIndicator.this.dotsWidthFactor - 1.0f) * positionOffset);
                    this.setDotWidth(nextDot, nextDotWidth);
                }
                this.lastPage = position;
            }

            private void setDotWidth(ImageView dot, int dotWidth) {
                ViewGroup.LayoutParams dotParams = dot.getLayoutParams();
                dotParams.width = dotWidth;
                dot.setLayoutParams(dotParams);
            }

            public void onPageSelected(int position) {
            }

            public void onPageScrollStateChanged(int state) {
            }
        };
    }

    private void setUpCircleColors(int color) {
        if (this.dots != null) {
            for (ImageView elevationItem : this.dots) {
                ((GradientDrawable)elevationItem.getBackground()).setColor(color);
            }
        }
    }

    private void setUpViewPager() {
        if (this.viewPager.getAdapter() != null) {
            this.viewPager.getAdapter().registerDataSetObserver(new DataSetObserver(){

                public void onChanged() {
                    super.onChanged();
                    DotsIndicator.this.refreshDots();
                }
            });
        }
    }

    private int dpToPx(int dp) {
        return (int)(this.getContext().getResources().getDisplayMetrics().density * (float)dp);
    }

    public void setPointsColor(int color) {
        this.setUpCircleColors(color);
    }

    public void setDotsClickable(boolean dotsClickable) {
        this.dotsClickable = dotsClickable;
    }

    public void setViewPager(ViewPager viewPager) {
        this.viewPager = viewPager;
        this.setUpViewPager();
        this.refreshDots();
    }
}

