/*
 * Decompiled with CFR 0.152.
 */
package com.tbuonomo.viewpagerdotsindicator;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.drawable.GradientDrawable;
import android.support.animation.FloatPropertyCompat;
import android.support.animation.SpringAnimation;
import android.support.animation.SpringForce;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.tbuonomo.viewpagerdotsindicator.R;
import com.tbuonomo.viewpagerdotsindicator.UiUtils;
import java.util.ArrayList;
import java.util.List;

public class SpringDotsIndicator
extends FrameLayout {
    public static final float DEFAULT_DAMPING_RATIO = 0.5f;
    public static final int DEFAULT_STIFFNESS = 300;
    private List<ImageView> strokeDots = new ArrayList<ImageView>();
    private View dotIndicatorView;
    private ViewPager viewPager;
    private int dotsStrokeSize;
    private int dotsSpacing;
    private int dotsStrokeWidth;
    private int dotsCornerRadius;
    private int dotsStrokeColor;
    private int dotIndicatorColor;
    private float stiffness;
    private float dampingRatio;
    private int dotIndicatorSize;
    private int dotIndicatorAdditionalSize;
    private int horizontalMargin;
    private SpringAnimation dotIndicatorSpring;
    private LinearLayout strokeDotsLinearLayout;
    private boolean dotsClickable;
    private ViewPager.OnPageChangeListener pageChangedListener;

    public SpringDotsIndicator(Context context) {
        this(context, null);
    }

    public SpringDotsIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SpringDotsIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.strokeDotsLinearLayout = new LinearLayout(context);
        FrameLayout.LayoutParams linearParams = new FrameLayout.LayoutParams(-2, -2);
        this.horizontalMargin = this.dpToPx(24);
        linearParams.setMargins(this.horizontalMargin, 0, this.horizontalMargin, 0);
        this.strokeDotsLinearLayout.setLayoutParams((ViewGroup.LayoutParams)linearParams);
        this.strokeDotsLinearLayout.setOrientation(0);
        this.addView((View)this.strokeDotsLinearLayout);
        this.dotsStrokeSize = this.dpToPx(16);
        this.dotsSpacing = this.dpToPx(4);
        this.dotsStrokeWidth = this.dpToPx(2);
        this.dotIndicatorAdditionalSize = this.dpToPx(1);
        this.dotsCornerRadius = this.dotsStrokeSize / 2;
        this.dotsStrokeColor = this.dotIndicatorColor = UiUtils.getThemePrimaryColor(context);
        this.stiffness = 300.0f;
        this.dampingRatio = 0.5f;
        this.dotsClickable = true;
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.SpringDotsIndicator);
            this.dotIndicatorColor = a.getColor(R.styleable.SpringDotsIndicator_dotsColor, this.dotIndicatorColor);
            this.dotsStrokeColor = a.getColor(R.styleable.SpringDotsIndicator_dotsStrokeColor, this.dotIndicatorColor);
            this.dotsStrokeSize = (int)a.getDimension(R.styleable.SpringDotsIndicator_dotsSize, (float)this.dotsStrokeSize);
            this.dotsSpacing = (int)a.getDimension(R.styleable.SpringDotsIndicator_dotsSpacing, (float)this.dotsSpacing);
            this.dotsCornerRadius = (int)a.getDimension(R.styleable.SpringDotsIndicator_dotsCornerRadius, (float)(this.dotsStrokeSize / 2));
            this.stiffness = a.getFloat(R.styleable.SpringDotsIndicator_stiffness, this.stiffness);
            this.dampingRatio = a.getFloat(R.styleable.SpringDotsIndicator_dampingRatio, this.dampingRatio);
            this.dotsStrokeWidth = (int)a.getDimension(R.styleable.SpringDotsIndicator_dotsStrokeWidth, (float)this.dotsStrokeWidth);
            a.recycle();
        }
        this.dotIndicatorSize = this.dotsStrokeSize - this.dotsStrokeWidth * 2 + this.dotIndicatorAdditionalSize;
        if (this.isInEditMode()) {
            this.addStrokeDots(5);
            this.addView((View)this.buildDot(false));
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.refreshDots();
    }

    private void refreshDots() {
        if (this.dotIndicatorView == null) {
            this.setUpDotIndicator();
        }
        if (this.viewPager != null && this.viewPager.getAdapter() != null) {
            if (this.strokeDots.size() < this.viewPager.getAdapter().getCount()) {
                this.addStrokeDots(this.viewPager.getAdapter().getCount() - this.strokeDots.size());
            } else if (this.strokeDots.size() > this.viewPager.getAdapter().getCount()) {
                this.removeDots(this.strokeDots.size() - this.viewPager.getAdapter().getCount());
            }
            this.setUpDotsAnimators();
        } else {
            Log.e((String)SpringDotsIndicator.class.getSimpleName(), (String)"You have to set an adapter to the view pager before !");
        }
    }

    private void setUpDotIndicator() {
        this.dotIndicatorView = this.buildDot(false);
        this.addView(this.dotIndicatorView);
        this.dotIndicatorSpring = new SpringAnimation((Object)this.dotIndicatorView, (FloatPropertyCompat)SpringAnimation.TRANSLATION_X);
        SpringForce springForce = new SpringForce(0.0f);
        springForce.setDampingRatio(this.dampingRatio);
        springForce.setStiffness(this.stiffness);
        this.dotIndicatorSpring.setSpring(springForce);
    }

    private void addStrokeDots(int count) {
        int i = 0;
        while (i < count) {
            ViewGroup dot = this.buildDot(true);
            final int finalI = i++;
            dot.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (SpringDotsIndicator.this.dotsClickable && SpringDotsIndicator.this.viewPager != null && SpringDotsIndicator.this.viewPager.getAdapter() != null && finalI < SpringDotsIndicator.this.viewPager.getAdapter().getCount()) {
                        SpringDotsIndicator.this.viewPager.setCurrentItem(finalI, true);
                    }
                }
            });
            this.strokeDots.add((ImageView)dot.findViewById(R.id.spring_dot));
            this.strokeDotsLinearLayout.addView((View)dot);
        }
    }

    private ViewGroup buildDot(boolean stroke) {
        ViewGroup dot = (ViewGroup)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.spring_dot_layout, (ViewGroup)this, false);
        ImageView dotView = (ImageView)dot.findViewById(R.id.spring_dot);
        dotView.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)(stroke ? R.drawable.spring_dot_stroke_background : R.drawable.spring_dot_background)));
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)dotView.getLayoutParams();
        params.height = stroke ? this.dotsStrokeSize : this.dotIndicatorSize;
        params.width = params.height;
        params.addRule(15, -1);
        params.setMargins(this.dotsSpacing, 0, this.dotsSpacing, 0);
        this.setUpDotBackground(stroke, (View)dotView);
        return dot;
    }

    private void setUpDotBackground(boolean stroke, View dotView) {
        GradientDrawable dotBackground = (GradientDrawable)dotView.getBackground();
        if (stroke) {
            dotBackground.setStroke(this.dotsStrokeWidth, this.dotsStrokeColor);
        } else {
            dotBackground.setColor(this.dotIndicatorColor);
        }
        dotBackground.setCornerRadius((float)this.dotsCornerRadius);
    }

    private void removeDots(int count) {
        for (int i = 0; i < count; ++i) {
            this.strokeDotsLinearLayout.removeViewAt(this.strokeDotsLinearLayout.getChildCount() - 1);
            this.strokeDots.remove(this.strokeDots.size() - 1);
        }
    }

    private void setUpDotsAnimators() {
        if (this.viewPager != null && this.viewPager.getAdapter() != null && this.viewPager.getAdapter().getCount() > 0) {
            if (this.pageChangedListener != null) {
                this.viewPager.removeOnPageChangeListener(this.pageChangedListener);
            }
            this.setUpOnPageChangedListener();
            this.viewPager.addOnPageChangeListener(this.pageChangedListener);
        }
    }

    private void setUpOnPageChangedListener() {
        this.pageChangedListener = new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                float globalPositionOffsetPixels = (float)(position * (SpringDotsIndicator.this.dotsStrokeSize + SpringDotsIndicator.this.dotsSpacing * 2)) + (float)(SpringDotsIndicator.this.dotsStrokeSize + SpringDotsIndicator.this.dotsSpacing * 2) * positionOffset;
                float indicatorTranslationX = globalPositionOffsetPixels + (float)SpringDotsIndicator.this.horizontalMargin + (float)SpringDotsIndicator.this.dotsStrokeWidth - (float)(SpringDotsIndicator.this.dotIndicatorAdditionalSize / 2);
                SpringDotsIndicator.this.dotIndicatorSpring.getSpring().setFinalPosition(indicatorTranslationX);
                if (!SpringDotsIndicator.this.dotIndicatorSpring.isRunning()) {
                    SpringDotsIndicator.this.dotIndicatorSpring.start();
                }
            }

            public void onPageSelected(int position) {
            }

            public void onPageScrollStateChanged(int state) {
            }
        };
    }

    private void setUpViewPager() {
        if (this.viewPager.getAdapter() != null) {
            this.viewPager.getAdapter().registerDataSetObserver(new DataSetObserver(){

                public void onChanged() {
                    super.onChanged();
                    SpringDotsIndicator.this.refreshDots();
                }
            });
        }
    }

    private int dpToPx(int dp) {
        return (int)(this.getContext().getResources().getDisplayMetrics().density * (float)dp);
    }

    public void setDotIndicatorColor(int color) {
        if (this.dotIndicatorView != null) {
            this.dotIndicatorColor = color;
            this.setUpDotBackground(false, this.dotIndicatorView);
        }
    }

    public void setStrokeDotsIndicatorColor(int color) {
        if (this.strokeDots != null && !this.strokeDots.isEmpty()) {
            this.dotsStrokeColor = color;
            for (ImageView v : this.strokeDots) {
                this.setUpDotBackground(true, (View)v);
            }
        }
    }

    public void setDotsClickable(boolean dotsClickable) {
        this.dotsClickable = dotsClickable;
    }

    public void setViewPager(ViewPager viewPager) {
        this.viewPager = viewPager;
        this.setUpViewPager();
        this.refreshDots();
    }
}

