/*
 * Decompiled with CFR 0.152.
 */
package com.tbuonomo.viewpagerdotsindicator;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.drawable.GradientDrawable;
import android.support.animation.FloatPropertyCompat;
import android.support.animation.SpringAnimation;
import android.support.animation.SpringForce;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.tbuonomo.viewpagerdotsindicator.R;
import com.tbuonomo.viewpagerdotsindicator.UiUtils;
import java.util.ArrayList;
import java.util.List;

public class WormDotsIndicator
extends FrameLayout {
    private List<ImageView> strokeDots = new ArrayList<ImageView>();
    private ImageView dotIndicatorView;
    private View dotIndicatorLayout;
    private ViewPager viewPager;
    private int dotsSize;
    private int dotsSpacing;
    private int dotsStrokeWidth;
    private int dotsCornerRadius;
    private int dotIndicatorColor;
    private int dotsStrokeColor;
    private int horizontalMargin;
    private SpringAnimation dotIndicatorXSpring;
    private SpringAnimation dotIndicatorWidthSpring;
    private LinearLayout strokeDotsLinearLayout;
    private boolean dotsClickable;
    private ViewPager.OnPageChangeListener pageChangedListener;

    public WormDotsIndicator(Context context) {
        this(context, null);
    }

    public WormDotsIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WormDotsIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.strokeDotsLinearLayout = new LinearLayout(context);
        FrameLayout.LayoutParams linearParams = new FrameLayout.LayoutParams(-2, -2);
        this.horizontalMargin = this.dpToPx(24);
        linearParams.setMargins(this.horizontalMargin, 0, this.horizontalMargin, 0);
        this.strokeDotsLinearLayout.setLayoutParams((ViewGroup.LayoutParams)linearParams);
        this.strokeDotsLinearLayout.setOrientation(0);
        this.addView((View)this.strokeDotsLinearLayout);
        this.dotsSize = this.dpToPx(16);
        this.dotsSpacing = this.dpToPx(4);
        this.dotsStrokeWidth = this.dpToPx(2);
        this.dotsCornerRadius = this.dotsSize / 2;
        this.dotsStrokeColor = this.dotIndicatorColor = UiUtils.getThemePrimaryColor(context);
        this.dotsClickable = true;
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.WormDotsIndicator);
            this.dotIndicatorColor = a.getColor(R.styleable.WormDotsIndicator_dotsColor, this.dotIndicatorColor);
            this.dotsStrokeColor = a.getColor(R.styleable.WormDotsIndicator_dotsStrokeColor, this.dotIndicatorColor);
            this.dotsSize = (int)a.getDimension(R.styleable.WormDotsIndicator_dotsSize, (float)this.dotsSize);
            this.dotsSpacing = (int)a.getDimension(R.styleable.WormDotsIndicator_dotsSpacing, (float)this.dotsSpacing);
            this.dotsCornerRadius = (int)a.getDimension(R.styleable.WormDotsIndicator_dotsCornerRadius, (float)(this.dotsSize / 2));
            this.dotsStrokeWidth = (int)a.getDimension(R.styleable.WormDotsIndicator_dotsStrokeWidth, (float)this.dotsStrokeWidth);
            a.recycle();
        }
        if (this.isInEditMode()) {
            this.addStrokeDots(5);
            this.addView((View)this.buildDot(false));
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.refreshDots();
    }

    private void refreshDots() {
        if (this.dotIndicatorLayout == null) {
            this.setUpDotIndicator();
        }
        if (this.viewPager != null && this.viewPager.getAdapter() != null) {
            if (this.strokeDots.size() < this.viewPager.getAdapter().getCount()) {
                this.addStrokeDots(this.viewPager.getAdapter().getCount() - this.strokeDots.size());
            } else if (this.strokeDots.size() > this.viewPager.getAdapter().getCount()) {
                this.removeDots(this.strokeDots.size() - this.viewPager.getAdapter().getCount());
            }
            this.setUpDotsAnimators();
        } else {
            Log.e((String)WormDotsIndicator.class.getSimpleName(), (String)"You have to set an adapter to the view pager before !");
        }
    }

    private void setUpDotIndicator() {
        this.dotIndicatorLayout = this.buildDot(false);
        this.dotIndicatorView = (ImageView)this.dotIndicatorLayout.findViewById(R.id.worm_dot);
        this.addView(this.dotIndicatorLayout);
        this.dotIndicatorXSpring = new SpringAnimation((Object)this.dotIndicatorLayout, (FloatPropertyCompat)SpringAnimation.TRANSLATION_X);
        SpringForce springForceX = new SpringForce(0.0f);
        springForceX.setDampingRatio(1.0f);
        springForceX.setStiffness(300.0f);
        this.dotIndicatorXSpring.setSpring(springForceX);
        FloatPropertyCompat floatPropertyCompat = new FloatPropertyCompat("DotsWidth"){

            public float getValue(Object object) {
                return ((WormDotsIndicator)WormDotsIndicator.this).dotIndicatorView.getLayoutParams().width;
            }

            public void setValue(Object object, float value) {
                ViewGroup.LayoutParams params = WormDotsIndicator.this.dotIndicatorView.getLayoutParams();
                params.width = (int)value;
                WormDotsIndicator.this.dotIndicatorView.requestLayout();
            }
        };
        this.dotIndicatorWidthSpring = new SpringAnimation((Object)this.dotIndicatorLayout, floatPropertyCompat);
        SpringForce springForceWidth = new SpringForce(0.0f);
        springForceWidth.setDampingRatio(1.0f);
        springForceWidth.setStiffness(300.0f);
        this.dotIndicatorWidthSpring.setSpring(springForceWidth);
    }

    private void addStrokeDots(int count) {
        int i = 0;
        while (i < count) {
            ViewGroup dot = this.buildDot(true);
            final int finalI = i++;
            dot.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (WormDotsIndicator.this.dotsClickable && WormDotsIndicator.this.viewPager != null && WormDotsIndicator.this.viewPager.getAdapter() != null && finalI < WormDotsIndicator.this.viewPager.getAdapter().getCount()) {
                        WormDotsIndicator.this.viewPager.setCurrentItem(finalI, true);
                    }
                }
            });
            this.strokeDots.add((ImageView)dot.findViewById(R.id.worm_dot));
            this.strokeDotsLinearLayout.addView((View)dot);
        }
    }

    private ViewGroup buildDot(boolean stroke) {
        ViewGroup dot = (ViewGroup)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.worm_dot_layout, (ViewGroup)this, false);
        View dotImageView = dot.findViewById(R.id.worm_dot);
        dotImageView.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)(stroke ? R.drawable.worm_dot_stroke_background : R.drawable.worm_dot_background)));
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)dotImageView.getLayoutParams();
        params.width = params.height = this.dotsSize;
        params.addRule(15, -1);
        params.setMargins(this.dotsSpacing, 0, this.dotsSpacing, 0);
        this.setUpDotBackground(stroke, dotImageView);
        return dot;
    }

    private void setUpDotBackground(boolean stroke, View dotImageView) {
        GradientDrawable dotBackground = (GradientDrawable)dotImageView.getBackground();
        if (stroke) {
            dotBackground.setStroke(this.dotsStrokeWidth, this.dotsStrokeColor);
        } else {
            dotBackground.setColor(this.dotIndicatorColor);
        }
        dotBackground.setCornerRadius((float)this.dotsCornerRadius);
    }

    private void removeDots(int count) {
        for (int i = 0; i < count; ++i) {
            this.strokeDotsLinearLayout.removeViewAt(this.strokeDotsLinearLayout.getChildCount() - 1);
            this.strokeDots.remove(this.strokeDots.size() - 1);
        }
    }

    private void setUpDotsAnimators() {
        if (this.viewPager != null && this.viewPager.getAdapter() != null && this.viewPager.getAdapter().getCount() > 0) {
            if (this.pageChangedListener != null) {
                this.viewPager.removeOnPageChangeListener(this.pageChangedListener);
            }
            this.setUpOnPageChangedListener();
            this.viewPager.addOnPageChangeListener(this.pageChangedListener);
        }
    }

    private void setUpOnPageChangedListener() {
        this.pageChangedListener = new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                float widthFinalPosition;
                float xFinalPosition;
                int stepX = WormDotsIndicator.this.dotsSize + WormDotsIndicator.this.dotsSpacing * 2;
                if (positionOffset >= 0.0f && positionOffset < 0.1f) {
                    xFinalPosition = WormDotsIndicator.this.horizontalMargin + position * stepX;
                    widthFinalPosition = WormDotsIndicator.this.dotsSize;
                } else if (positionOffset >= 0.1f && positionOffset <= 0.9f) {
                    xFinalPosition = WormDotsIndicator.this.horizontalMargin + position * stepX;
                    widthFinalPosition = WormDotsIndicator.this.dotsSize + stepX;
                } else {
                    xFinalPosition = WormDotsIndicator.this.horizontalMargin + (position + 1) * stepX;
                    widthFinalPosition = WormDotsIndicator.this.dotsSize;
                }
                if (WormDotsIndicator.this.dotIndicatorXSpring.getSpring().getFinalPosition() != xFinalPosition) {
                    WormDotsIndicator.this.dotIndicatorXSpring.getSpring().setFinalPosition(xFinalPosition);
                }
                if (WormDotsIndicator.this.dotIndicatorWidthSpring.getSpring().getFinalPosition() != widthFinalPosition) {
                    WormDotsIndicator.this.dotIndicatorWidthSpring.getSpring().setFinalPosition(widthFinalPosition);
                }
                if (!WormDotsIndicator.this.dotIndicatorXSpring.isRunning()) {
                    WormDotsIndicator.this.dotIndicatorXSpring.start();
                }
                if (!WormDotsIndicator.this.dotIndicatorWidthSpring.isRunning()) {
                    WormDotsIndicator.this.dotIndicatorWidthSpring.start();
                }
            }

            public void onPageSelected(int position) {
            }

            public void onPageScrollStateChanged(int state) {
            }
        };
    }

    private void setUpViewPager() {
        if (this.viewPager.getAdapter() != null) {
            this.viewPager.getAdapter().registerDataSetObserver(new DataSetObserver(){

                public void onChanged() {
                    super.onChanged();
                    WormDotsIndicator.this.refreshDots();
                }
            });
        }
    }

    private int dpToPx(int dp) {
        return (int)(this.getContext().getResources().getDisplayMetrics().density * (float)dp);
    }

    public void setDotIndicatorColor(int color) {
        if (this.dotIndicatorView != null) {
            this.dotIndicatorColor = color;
            this.setUpDotBackground(false, (View)this.dotIndicatorView);
        }
    }

    public void setStrokeDotsIndicatorColor(int color) {
        if (this.strokeDots != null && !this.strokeDots.isEmpty()) {
            this.dotsStrokeColor = color;
            for (ImageView v : this.strokeDots) {
                this.setUpDotBackground(true, (View)v);
            }
        }
    }

    public void setDotsClickable(boolean dotsClickable) {
        this.dotsClickable = dotsClickable;
    }

    public void setViewPager(ViewPager viewPager) {
        this.viewPager = viewPager;
        this.setUpViewPager();
        this.refreshDots();
    }
}

