/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.modelmsg;

import android.os.Bundle;
import com.tencent.mm.opensdk.modelmsg.WXMediaMessage;
import com.tencent.mm.opensdk.utils.Log;
import com.tencent.mm.opensdk.utils.d;

public class WXFileObject
implements WXMediaMessage.IMediaObject {
    private static final String TAG = "MicroMsg.SDK.WXFileObject";
    private static final int CONTENT_LENGTH_LIMIT = 0xA00000;
    private int contentLengthLimit = 0xA00000;
    public byte[] fileData;
    public String filePath;

    public WXFileObject() {
        this.fileData = null;
        this.filePath = null;
    }

    public WXFileObject(byte[] byArray) {
        this.fileData = byArray;
    }

    public WXFileObject(String string) {
        this.filePath = string;
    }

    public void setFileData(byte[] byArray) {
        this.fileData = byArray;
    }

    public void setFilePath(String string) {
        this.filePath = string;
    }

    @Override
    public void serialize(Bundle bundle) {
        bundle.putByteArray("_wxfileobject_fileData", this.fileData);
        bundle.putString("_wxfileobject_filePath", this.filePath);
    }

    @Override
    public void unserialize(Bundle bundle) {
        this.fileData = bundle.getByteArray("_wxfileobject_fileData");
        this.filePath = bundle.getString("_wxfileobject_filePath");
    }

    @Override
    public int type() {
        return 6;
    }

    public void setContentLengthLimit(int n) {
        this.contentLengthLimit = n;
    }

    @Override
    public boolean checkArgs() {
        if (!(this.fileData != null && this.fileData.length != 0 || this.filePath != null && this.filePath.length() != 0)) {
            Log.e(TAG, "checkArgs fail, both arguments is null");
            return false;
        }
        if (this.fileData != null && this.fileData.length > this.contentLengthLimit) {
            Log.e(TAG, "checkArgs fail, fileData is too large");
            return false;
        }
        if (this.filePath != null && this.getFileSize(this.filePath) > this.contentLengthLimit) {
            Log.e(TAG, "checkArgs fail, fileSize is too large");
            return false;
        }
        return true;
    }

    private int getFileSize(String string) {
        return d.getFileSize(string);
    }
}

