/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import parquet.bytes.BytesUtils;
import parquet.hadoop.metadata.BlockMetaData;

@InterfaceAudience.Private
public class ParquetInputSplit
extends FileSplit
implements Writable {
    private long end;
    private long[] rowGroupOffsets;
    private String requestedSchema;
    private Map<String, String> readSupportMetadata;

    public ParquetInputSplit() {
        super(null, 0L, 0L, new String[0]);
    }

    @Deprecated
    public ParquetInputSplit(Path path, long start, long length, String[] hosts, List<BlockMetaData> blocks, String requestedSchema, String fileSchema, Map<String, String> extraMetadata, Map<String, String> readSupportMetadata) {
        this(path, start, length, ParquetInputSplit.end(blocks), hosts, ParquetInputSplit.offsets(blocks), requestedSchema, readSupportMetadata);
    }

    private static long end(List<BlockMetaData> blocks) {
        BlockMetaData last = blocks.get(blocks.size() - 1);
        return last.getStartingPos() + last.getCompressedSize();
    }

    private static long[] offsets(List<BlockMetaData> blocks) {
        long[] offsets = new long[blocks.size()];
        for (int i = 0; i < offsets.length; ++i) {
            offsets[i] = blocks.get(0).getStartingPos();
        }
        return offsets;
    }

    public ParquetInputSplit(Path file, long start, long end, long length, String[] hosts, long[] rowGroupOffsets, String requestedSchema, Map<String, String> readSupportMetadata) {
        super(file, start, length, hosts);
        this.end = end;
        this.rowGroupOffsets = rowGroupOffsets;
        this.requestedSchema = requestedSchema;
        this.readSupportMetadata = readSupportMetadata;
    }

    String getRequestedSchema() {
        return this.requestedSchema;
    }

    long getEnd() {
        return this.end;
    }

    Map<String, String> getReadSupportMetadata() {
        return this.readSupportMetadata;
    }

    long[] getRowGroupOffsets() {
        return this.rowGroupOffsets;
    }

    public String toString() {
        String hosts;
        try {
            hosts = Arrays.toString(this.getLocations());
        }
        catch (Exception e) {
            hosts = "(" + e + ")";
        }
        return ((Object)((Object)this)).getClass().getSimpleName() + "{" + "part: " + this.getPath() + " start: " + this.getStart() + " end: " + this.getEnd() + " length: " + this.getLength() + " hosts: " + hosts + (this.rowGroupOffsets == null ? "" : " row groups: " + Arrays.toString(this.rowGroupOffsets)) + " requestedSchema: " + this.requestedSchema + " readSupportMetadata: " + this.readSupportMetadata + "}";
    }

    public final void readFields(DataInput hin) throws IOException {
        byte[] bytes = ParquetInputSplit.readArray(hin);
        DataInputStream in = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(bytes)));
        super.readFields((DataInput)in);
        this.end = in.readLong();
        if (in.readBoolean()) {
            this.rowGroupOffsets = new long[in.readInt()];
            for (int i = 0; i < this.rowGroupOffsets.length; ++i) {
                this.rowGroupOffsets[i] = in.readLong();
            }
        }
        this.requestedSchema = ParquetInputSplit.readUTF8(in);
        this.readSupportMetadata = this.readKeyValues(in);
        in.close();
    }

    public final void write(DataOutput hout) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(new GZIPOutputStream(baos));
        super.write((DataOutput)out);
        out.writeLong(this.end);
        out.writeBoolean(this.rowGroupOffsets != null);
        if (this.rowGroupOffsets != null) {
            out.writeInt(this.rowGroupOffsets.length);
            for (long o : this.rowGroupOffsets) {
                out.writeLong(o);
            }
        }
        ParquetInputSplit.writeUTF8(out, this.requestedSchema);
        this.writeKeyValues(out, this.readSupportMetadata);
        out.close();
        ParquetInputSplit.writeArray(hout, baos.toByteArray());
    }

    private static void writeUTF8(DataOutput out, String string) throws IOException {
        byte[] bytes = string.getBytes(BytesUtils.UTF8);
        ParquetInputSplit.writeArray(out, bytes);
    }

    private static String readUTF8(DataInput in) throws IOException {
        byte[] bytes = ParquetInputSplit.readArray(in);
        return new String(bytes, BytesUtils.UTF8).intern();
    }

    private static void writeArray(DataOutput out, byte[] bytes) throws IOException {
        out.writeInt(bytes.length);
        out.write(bytes, 0, bytes.length);
    }

    private static byte[] readArray(DataInput in) throws IOException {
        int len = in.readInt();
        byte[] bytes = new byte[len];
        in.readFully(bytes);
        return bytes;
    }

    private Map<String, String> readKeyValues(DataInput in) throws IOException {
        int size = in.readInt();
        HashMap<String, String> map = new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            String key = ParquetInputSplit.readUTF8(in).intern();
            String value = ParquetInputSplit.readUTF8(in).intern();
            map.put(key, value);
        }
        return map;
    }

    private void writeKeyValues(DataOutput out, Map<String, String> map) throws IOException {
        if (map == null) {
            out.writeInt(0);
        } else {
            out.writeInt(map.size());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                ParquetInputSplit.writeUTF8(out, entry.getKey());
                ParquetInputSplit.writeUTF8(out, entry.getValue());
            }
        }
    }
}

