/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import com.twitter.sdk.android.core.Callback;
import com.twitter.sdk.android.core.Result;
import com.twitter.sdk.android.core.TwitterException;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.tweetui.TimelineCursor;
import com.twitter.sdk.android.tweetui.TimelineResult;
import java.util.List;

abstract class BaseTimeline {
    BaseTimeline() {
    }

    abstract String getTimelineType();

    static Long decrementMaxId(Long maxId) {
        return maxId == null ? null : Long.valueOf(maxId - 1L);
    }

    static class TweetsCallback
    extends Callback<List<Tweet>> {
        final Callback<TimelineResult<Tweet>> cb;

        TweetsCallback(Callback<TimelineResult<Tweet>> cb) {
            this.cb = cb;
        }

        public void success(Result<List<Tweet>> result) {
            List tweets = (List)result.data;
            TimelineResult timelineResult = new TimelineResult(new TimelineCursor(tweets), tweets);
            if (this.cb != null) {
                this.cb.success(new Result(timelineResult, result.response));
            }
        }

        public void failure(TwitterException exception) {
            if (this.cb != null) {
                this.cb.failure(exception);
            }
        }
    }
}

