/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import com.twitter.sdk.android.core.Callback;
import com.twitter.sdk.android.core.Result;
import com.twitter.sdk.android.core.TwitterException;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.tweetui.BaseTweetView;
import com.twitter.sdk.android.tweetui.TweetRepository;

class ResetTweetCallback
extends Callback<Tweet> {
    final BaseTweetView baseTweetView;
    final TweetRepository tweetRepository;
    final Callback<Tweet> cb;

    ResetTweetCallback(BaseTweetView baseTweetView, TweetRepository tweetRepository, Callback<Tweet> cb) {
        this.baseTweetView = baseTweetView;
        this.tweetRepository = tweetRepository;
        this.cb = cb;
    }

    public void success(Result<Tweet> result) {
        this.tweetRepository.updateCache((Tweet)result.data);
        this.baseTweetView.setTweet((Tweet)result.data);
        if (this.cb != null) {
            this.cb.success(result);
        }
    }

    public void failure(TwitterException exception) {
        if (this.cb != null) {
            this.cb.failure(exception);
        }
    }
}

