/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import com.twitter.sdk.android.core.Callback;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.tweetui.LikeTweetAction;
import com.twitter.sdk.android.tweetui.R;
import com.twitter.sdk.android.tweetui.ShareTweetAction;
import com.twitter.sdk.android.tweetui.ToggleImageButton;
import com.twitter.sdk.android.tweetui.TweetUi;

public class TweetActionBarView
extends LinearLayout {
    final DependencyProvider dependencyProvider;
    ToggleImageButton likeButton;
    ImageButton shareButton;
    Callback<Tweet> actionCallback;

    public TweetActionBarView(Context context) {
        this(context, null, new DependencyProvider());
    }

    public TweetActionBarView(Context context, AttributeSet attrs) {
        this(context, attrs, new DependencyProvider());
    }

    TweetActionBarView(Context context, AttributeSet attrs, DependencyProvider dependencyProvider) {
        super(context, attrs);
        this.dependencyProvider = dependencyProvider;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.findSubviews();
    }

    void setOnActionCallback(Callback<Tweet> actionCallback) {
        this.actionCallback = actionCallback;
    }

    void findSubviews() {
        this.likeButton = (ToggleImageButton)this.findViewById(R.id.tw__tweet_like_button);
        this.shareButton = (ImageButton)this.findViewById(R.id.tw__tweet_share_button);
    }

    void setTweet(Tweet tweet) {
        this.setLike(tweet);
        this.setShare(tweet);
    }

    void setLike(Tweet tweet) {
        TweetUi tweetUi = this.dependencyProvider.getTweetUi();
        if (tweet != null) {
            this.likeButton.setToggledOn(tweet.favorited);
            LikeTweetAction likeTweetAction = new LikeTweetAction(tweet, tweetUi, this.actionCallback);
            this.likeButton.setOnClickListener(likeTweetAction);
        }
    }

    void setShare(Tweet tweet) {
        TweetUi tweetUi = this.dependencyProvider.getTweetUi();
        if (tweet != null) {
            this.shareButton.setOnClickListener((View.OnClickListener)new ShareTweetAction(tweet, tweetUi));
        }
    }

    static class DependencyProvider {
        DependencyProvider() {
        }

        TweetUi getTweetUi() {
            return TweetUi.getInstance();
        }
    }
}

