/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import android.text.TextUtils;
import com.twitter.sdk.android.core.models.HashtagEntity;
import com.twitter.sdk.android.core.models.MediaEntity;
import com.twitter.sdk.android.core.models.MentionEntity;
import com.twitter.sdk.android.core.models.SymbolEntity;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.core.models.UrlEntity;
import com.twitter.sdk.android.tweetui.FormattedMediaEntity;
import com.twitter.sdk.android.tweetui.FormattedTweetText;
import com.twitter.sdk.android.tweetui.FormattedUrlEntity;
import com.twitter.sdk.android.tweetui.internal.util.HtmlEntities;
import java.util.ArrayList;
import java.util.List;

final class TweetTextUtils {
    private TweetTextUtils() {
    }

    static FormattedTweetText formatTweetText(Tweet tweet) {
        if (tweet == null) {
            return null;
        }
        FormattedTweetText adjustedTweet = new FormattedTweetText();
        TweetTextUtils.convertEntities(adjustedTweet, tweet);
        TweetTextUtils.format(adjustedTweet, tweet);
        return adjustedTweet;
    }

    static void convertEntities(FormattedTweetText formattedTweetText, Tweet tweet) {
        List coreSymbols;
        List coreMentions;
        List coreHashtags;
        List coreMedia;
        if (tweet.entities == null) {
            return;
        }
        List coreUrls = tweet.entities.urls;
        if (coreUrls != null) {
            for (UrlEntity entity : coreUrls) {
                FormattedUrlEntity formattedUrlEntity = FormattedUrlEntity.createFormattedUrlEntity(entity);
                formattedTweetText.urlEntities.add(formattedUrlEntity);
            }
        }
        if ((coreMedia = tweet.entities.media) != null) {
            for (MediaEntity entity : coreMedia) {
                FormattedMediaEntity formattedMediaEntity = new FormattedMediaEntity(entity);
                formattedTweetText.mediaEntities.add(formattedMediaEntity);
            }
        }
        if ((coreHashtags = tweet.entities.hashtags) != null) {
            for (HashtagEntity entity : coreHashtags) {
                FormattedUrlEntity formattedHashtagEntity = FormattedUrlEntity.createFormattedUrlEntity(entity);
                formattedTweetText.hashtagEntities.add(formattedHashtagEntity);
            }
        }
        if ((coreMentions = tweet.entities.userMentions) != null) {
            for (MentionEntity entity : coreMentions) {
                FormattedUrlEntity formattedMentionEntity = FormattedUrlEntity.createFormattedUrlEntity(entity);
                formattedTweetText.mentionEntities.add(formattedMentionEntity);
            }
        }
        if ((coreSymbols = tweet.entities.symbols) != null) {
            for (SymbolEntity entity : coreSymbols) {
                FormattedUrlEntity formattedSymbolEntity = FormattedUrlEntity.createFormattedUrlEntity(entity);
                formattedTweetText.symbolEntities.add(formattedSymbolEntity);
            }
        }
    }

    static void format(FormattedTweetText formattedTweetText, Tweet tweet) {
        if (TextUtils.isEmpty((CharSequence)tweet.text)) {
            return;
        }
        HtmlEntities.Unescaped u = HtmlEntities.HTML40.unescape(tweet.text);
        StringBuilder result = new StringBuilder(u.unescaped);
        TweetTextUtils.adjustIndicesForEscapedChars(formattedTweetText.urlEntities, u.indices);
        TweetTextUtils.adjustIndicesForEscapedChars(formattedTweetText.mediaEntities, u.indices);
        TweetTextUtils.adjustIndicesForEscapedChars(formattedTweetText.hashtagEntities, u.indices);
        TweetTextUtils.adjustIndicesForEscapedChars(formattedTweetText.mentionEntities, u.indices);
        TweetTextUtils.adjustIndicesForEscapedChars(formattedTweetText.symbolEntities, u.indices);
        TweetTextUtils.adjustIndicesForSupplementaryChars(result, formattedTweetText);
        formattedTweetText.text = result.toString();
    }

    static void adjustIndicesForEscapedChars(List<? extends FormattedUrlEntity> entities, List<int[]> indices) {
        if (entities == null || indices == null || indices.isEmpty()) {
            return;
        }
        int size = indices.size();
        int m = 0;
        int diff = 0;
        for (FormattedUrlEntity formattedUrlEntity : entities) {
            int inDiff = 0;
            for (int i = m; i < size; ++i) {
                int[] index = indices.get(i);
                int start = index[0];
                int end = index[1];
                int len = end - start;
                if (end < formattedUrlEntity.start) {
                    diff += len;
                    ++m;
                    continue;
                }
                if (end >= formattedUrlEntity.end) continue;
                inDiff += len;
            }
            formattedUrlEntity.start -= diff + inDiff;
            formattedUrlEntity.end -= diff + inDiff;
        }
    }

    static void adjustIndicesForSupplementaryChars(StringBuilder content, FormattedTweetText formattedTweetText) {
        ArrayList<Integer> highSurrogateIndices = new ArrayList<Integer>();
        int len = content.length() - 1;
        for (int i = 0; i < len; ++i) {
            if (!Character.isHighSurrogate(content.charAt(i)) || !Character.isLowSurrogate(content.charAt(i + 1))) continue;
            highSurrogateIndices.add(i);
        }
        TweetTextUtils.adjustEntitiesWithOffsets(formattedTweetText.urlEntities, highSurrogateIndices);
        TweetTextUtils.adjustEntitiesWithOffsets(formattedTweetText.mediaEntities, highSurrogateIndices);
        TweetTextUtils.adjustEntitiesWithOffsets(formattedTweetText.hashtagEntities, highSurrogateIndices);
        TweetTextUtils.adjustEntitiesWithOffsets(formattedTweetText.mentionEntities, highSurrogateIndices);
        TweetTextUtils.adjustEntitiesWithOffsets(formattedTweetText.symbolEntities, highSurrogateIndices);
    }

    static void adjustEntitiesWithOffsets(List<? extends FormattedUrlEntity> entities, List<Integer> indices) {
        if (entities == null || indices == null) {
            return;
        }
        for (FormattedUrlEntity formattedUrlEntity : entities) {
            int start = formattedUrlEntity.start;
            int offset = 0;
            for (Integer index : indices) {
                if (index - offset > start) break;
                ++offset;
            }
            formattedUrlEntity.start += offset;
            formattedUrlEntity.end += offset;
        }
    }
}

