/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.twitter.sdk.android.core.Callback;
import com.twitter.sdk.android.core.Result;
import com.twitter.sdk.android.core.TwitterException;
import com.twitter.sdk.android.core.internal.scribe.ScribeItem;
import com.twitter.sdk.android.core.models.Identifiable;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.tweetui.BaseTimeline;
import com.twitter.sdk.android.tweetui.BaseTweetView;
import com.twitter.sdk.android.tweetui.CompactTweetView;
import com.twitter.sdk.android.tweetui.FilterTimelineDelegate;
import com.twitter.sdk.android.tweetui.R;
import com.twitter.sdk.android.tweetui.ScribeConstants;
import com.twitter.sdk.android.tweetui.Timeline;
import com.twitter.sdk.android.tweetui.TimelineDelegate;
import com.twitter.sdk.android.tweetui.TimelineFilter;
import com.twitter.sdk.android.tweetui.TimelineListAdapter;
import com.twitter.sdk.android.tweetui.TweetUi;
import java.util.ArrayList;

public class TweetTimelineListAdapter
extends TimelineListAdapter<Tweet> {
    protected Callback<Tweet> actionCallback;
    protected final int styleResId;
    protected TweetUi tweetUi;
    static final String TOTAL_FILTERS_JSON_PROP = "total_filters";
    static final String DEFAULT_FILTERS_JSON_MSG = "{\"total_filters\":0}";
    final Gson gson = new Gson();

    public TweetTimelineListAdapter(Context context, Timeline<Tweet> timeline) {
        this(context, timeline, R.style.tw__TweetLightStyle, null);
    }

    TweetTimelineListAdapter(Context context, Timeline<Tweet> timeline, int styleResId, Callback<Tweet> cb) {
        this(context, new TimelineDelegate<Tweet>(timeline), styleResId, cb, TweetUi.getInstance());
    }

    TweetTimelineListAdapter(Context context, TimelineDelegate<Tweet> delegate, int styleResId, Callback<Tweet> cb, TweetUi tweetUi) {
        super(context, delegate);
        this.styleResId = styleResId;
        this.actionCallback = new ReplaceTweetCallback(delegate, cb);
        this.tweetUi = tweetUi;
        this.scribeTimelineImpression();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Object rowView = convertView;
        Tweet tweet = (Tweet)this.getItem(position);
        if (rowView == null) {
            CompactTweetView tv = new CompactTweetView(this.context, tweet, this.styleResId);
            tv.setOnActionCallback(this.actionCallback);
            rowView = tv;
        } else {
            ((BaseTweetView)((Object)rowView)).setTweet(tweet);
        }
        return rowView;
    }

    private void scribeTimelineImpression() {
        String jsonMessage;
        if (this.delegate instanceof FilterTimelineDelegate) {
            FilterTimelineDelegate filterTimelineDelegate = (FilterTimelineDelegate)this.delegate;
            TimelineFilter timelineFilter = filterTimelineDelegate.timelineFilter;
            jsonMessage = this.getJsonMessage(timelineFilter.totalFilters());
        } else {
            jsonMessage = DEFAULT_FILTERS_JSON_MSG;
        }
        ScribeItem scribeItem = ScribeItem.fromMessage((String)jsonMessage);
        ArrayList<ScribeItem> items = new ArrayList<ScribeItem>();
        items.add(scribeItem);
        String timelineType = TweetTimelineListAdapter.getTimelineType(this.delegate.getTimeline());
        this.tweetUi.scribe(ScribeConstants.getSyndicatedSdkTimelineNamespace(timelineType));
        this.tweetUi.scribe(ScribeConstants.getTfwClientTimelineNamespace(timelineType), items);
    }

    private String getJsonMessage(int totalFilters) {
        JsonObject message = new JsonObject();
        message.addProperty(TOTAL_FILTERS_JSON_PROP, (Number)totalFilters);
        return this.gson.toJson((JsonElement)message);
    }

    static String getTimelineType(Timeline timeline) {
        if (timeline instanceof BaseTimeline) {
            return ((BaseTimeline)((Object)timeline)).getTimelineType();
        }
        return "other";
    }

    public static class Builder {
        private Context context;
        private Timeline<Tweet> timeline;
        private Callback<Tweet> actionCallback;
        private TimelineFilter timelineFilter;
        private int styleResId = R.style.tw__TweetLightStyle;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder setTimeline(Timeline<Tweet> timeline) {
            this.timeline = timeline;
            return this;
        }

        public Builder setViewStyle(int styleResId) {
            this.styleResId = styleResId;
            return this;
        }

        public Builder setOnActionCallback(Callback<Tweet> actionCallback) {
            this.actionCallback = actionCallback;
            return this;
        }

        public Builder setTimelineFilter(TimelineFilter timelineFilter) {
            this.timelineFilter = timelineFilter;
            return this;
        }

        public TweetTimelineListAdapter build() {
            if (this.timelineFilter == null) {
                return new TweetTimelineListAdapter(this.context, this.timeline, this.styleResId, this.actionCallback);
            }
            FilterTimelineDelegate delegate = new FilterTimelineDelegate(this.timeline, this.timelineFilter);
            return new TweetTimelineListAdapter(this.context, delegate, this.styleResId, this.actionCallback, TweetUi.getInstance());
        }
    }

    static class ReplaceTweetCallback
    extends Callback<Tweet> {
        TimelineDelegate<Tweet> delegate;
        Callback<Tweet> cb;

        ReplaceTweetCallback(TimelineDelegate<Tweet> delegate, Callback<Tweet> cb) {
            this.delegate = delegate;
            this.cb = cb;
        }

        public void success(Result<Tweet> result) {
            this.delegate.setItemById((Tweet)((Identifiable)result.data));
            if (this.cb != null) {
                this.cb.success(result);
            }
        }

        public void failure(TwitterException exception) {
            if (this.cb != null) {
                this.cb.failure(exception);
            }
        }
    }
}

