/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt.plugin;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.unfbx.chatgpt.entity.chat.Parameters;
import com.unfbx.chatgpt.plugin.PluginParam;
import java.util.List;
import java.util.stream.Collectors;

public abstract class PluginAbstract<R extends PluginParam, T> {
    private Class<?> R;
    private String name;
    private String function;
    private String description;
    private List<Arg> args;
    private List<String> required;
    private Parameters parameters;

    public PluginAbstract(Class<?> r) {
        this.R = r;
    }

    public void setRequired(List<String> required) {
        if (CollectionUtil.isEmpty(required)) {
            this.required = this.getArgs().stream().filter(e -> e.isRequired()).map(Arg::getName).collect(Collectors.toList());
            return;
        }
        this.required = required;
    }

    private void setRequired() {
        if (CollectionUtil.isEmpty(this.required)) {
            this.required = this.getArgs().stream().filter(e -> e.isRequired()).map(Arg::getName).collect(Collectors.toList());
        }
    }

    private void setParameters() {
        JSONObject properties = new JSONObject();
        this.args.forEach(e -> {
            JSONObject param = new JSONObject();
            param.putOpt("type", (Object)e.getType());
            param.putOpt("enum", e.getEnumDictValue());
            param.putOpt("description", (Object)e.getDescription());
            properties.putOpt(e.getName(), (Object)param);
        });
        this.parameters = Parameters.builder().type("object").properties(properties).required(this.getRequired()).build();
    }

    public void setArgs(List<Arg> args) {
        this.args = args;
        this.setRequired();
        this.setParameters();
    }

    public abstract T func(R var1);

    public abstract String content(T var1);

    public Class<?> getR() {
        return this.R;
    }

    public String getName() {
        return this.name;
    }

    public String getFunction() {
        return this.function;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Arg> getArgs() {
        return this.args;
    }

    public List<String> getRequired() {
        return this.required;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public void setR(Class<?> R) {
        this.R = R;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PluginAbstract)) {
            return false;
        }
        PluginAbstract other = (PluginAbstract)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<?> this$R = this.getR();
        Class<?> other$R = other.getR();
        if (this$R == null ? other$R != null : !this$R.equals(other$R)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$function = this.getFunction();
        String other$function = other.getFunction();
        if (this$function == null ? other$function != null : !this$function.equals(other$function)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<Arg> this$args = this.getArgs();
        List<Arg> other$args = other.getArgs();
        if (this$args == null ? other$args != null : !((Object)this$args).equals(other$args)) {
            return false;
        }
        List<String> this$required = this.getRequired();
        List<String> other$required = other.getRequired();
        if (this$required == null ? other$required != null : !((Object)this$required).equals(other$required)) {
            return false;
        }
        Parameters this$parameters = this.getParameters();
        Parameters other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PluginAbstract;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $R = this.getR();
        result = result * 59 + ($R == null ? 43 : $R.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $function = this.getFunction();
        result = result * 59 + ($function == null ? 43 : $function.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<Arg> $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        List<String> $required = this.getRequired();
        result = result * 59 + ($required == null ? 43 : ((Object)$required).hashCode());
        Parameters $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    public String toString() {
        return "PluginAbstract(R=" + this.getR() + ", name=" + this.getName() + ", function=" + this.getFunction() + ", description=" + this.getDescription() + ", args=" + this.getArgs() + ", required=" + this.getRequired() + ", parameters=" + this.getParameters() + ")";
    }

    public PluginAbstract(Class<?> R, String name, String function, String description, List<Arg> args, List<String> required, Parameters parameters) {
        this.R = R;
        this.name = name;
        this.function = function;
        this.description = description;
        this.args = args;
        this.required = required;
        this.parameters = parameters;
    }

    public static class Arg {
        private String name;
        private String type;
        private String description;
        @JsonIgnore
        private boolean enumDict;
        @JsonProperty(value="enum")
        private List<String> enumDictValue;
        @JsonIgnore
        private boolean required;

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isEnumDict() {
            return this.enumDict;
        }

        public List<String> getEnumDictValue() {
            return this.enumDictValue;
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @JsonIgnore
        public void setEnumDict(boolean enumDict) {
            this.enumDict = enumDict;
        }

        @JsonProperty(value="enum")
        public void setEnumDictValue(List<String> enumDictValue) {
            this.enumDictValue = enumDictValue;
        }

        @JsonIgnore
        public void setRequired(boolean required) {
            this.required = required;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Arg)) {
                return false;
            }
            Arg other = (Arg)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnumDict() != other.isEnumDict()) {
                return false;
            }
            if (this.isRequired() != other.isRequired()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            List<String> this$enumDictValue = this.getEnumDictValue();
            List<String> other$enumDictValue = other.getEnumDictValue();
            return !(this$enumDictValue == null ? other$enumDictValue != null : !((Object)this$enumDictValue).equals(other$enumDictValue));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Arg;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnumDict() ? 79 : 97);
            result = result * 59 + (this.isRequired() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            List<String> $enumDictValue = this.getEnumDictValue();
            result = result * 59 + ($enumDictValue == null ? 43 : ((Object)$enumDictValue).hashCode());
            return result;
        }

        public String toString() {
            return "PluginAbstract.Arg(name=" + this.getName() + ", type=" + this.getType() + ", description=" + this.getDescription() + ", enumDict=" + this.isEnumDict() + ", enumDictValue=" + this.getEnumDictValue() + ", required=" + this.isRequired() + ")";
        }
    }
}

