/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.maas.impl;

import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import com.volcengine.error.SdkError;
import com.volcengine.model.maas.api.Api;
import com.volcengine.model.response.RawResponse;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.SignableRequest;
import com.volcengine.service.maas.MaasConfig;
import com.volcengine.service.maas.MaasException;
import com.volcengine.service.maas.MaasService;
import com.volcengine.service.maas.impl.SseEvent;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public class MaasServiceImpl
extends BaseServiceImpl
implements MaasService {
    private static final String CHAT_TERMINATOR = "[DONE]";

    public MaasServiceImpl(String host, String region) {
        this(host, region, 60000, 60000);
    }

    public MaasServiceImpl(String host, String region, int connectionTimeout, int socketTimeout) {
        super(MaasConfig.getServiceInfo(host, region, connectionTimeout, socketTimeout), MaasConfig.getApiInfoList());
    }

    @Override
    public Api.ChatResp chat(Api.ChatReq req) throws MaasException {
        RawResponse response = this.json("chat", null, MaasServiceImpl.json_dumps(req = req.toBuilder().setStream(false).build()));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            Api.ChatResp resp;
            try {
                resp = MaasServiceImpl.convertJsonBytesToChatResp(response.getException().getMessage().getBytes());
            }
            catch (MaasException ignored) {
                throw new MaasException(response.getException(), response.getHttpCode(), req.getReqId());
            }
            throw new MaasException(resp.getError(), resp.getReqId());
        }
        return MaasServiceImpl.convertJsonBytesToChatResp(response.getData());
    }

    @Override
    public Stream<Api.ChatResp> streamChat(Api.ChatReq req) throws MaasException {
        InputStream is;
        HttpResponse response;
        req = req.toBuilder().setStream(true).build();
        SignableRequest request = this.prepareRequest("chat", null);
        request.setHeader("Content-Type", "application/json");
        request.setEntity((HttpEntity)new StringEntity(MaasServiceImpl.json_dumps(req), "utf-8"));
        try {
            this.ISigner.sign(request, this.credentials);
        }
        catch (Exception e) {
            throw new MaasException(e, req.getReqId());
        }
        try {
            response = this.getHttpClient().execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            throw new MaasException(e, req.getReqId());
        }
        try {
            is = response.getEntity().getContent();
        }
        catch (IOException e) {
            throw new MaasException(e, req.getReqId());
        }
        return SseEvent.fromInputStream(is, StandardCharsets.UTF_8).map(event -> {
            Api.ChatResp resp;
            if (event.getData().trim().equals(CHAT_TERMINATOR)) {
                return null;
            }
            try {
                resp = MaasServiceImpl.convertJsonBytesToChatResp(event.getData().getBytes());
            }
            catch (MaasException e) {
                this.closeInputStream(is);
                throw new RuntimeException(e);
            }
            if (resp.getError().getCodeN() != 0) {
                this.closeInputStream(is);
                throw new RuntimeException(new MaasException(resp.getError(), resp.getReqId()));
            }
            return resp;
        }).filter(Objects::nonNull);
    }

    @Override
    public Api.TokenizeResp tokenization(Api.TokenizeReq req) throws MaasException {
        RawResponse response = this.json("tokenization", null, MaasServiceImpl.json_dumps(req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            Api.TokenizeResp resp;
            try {
                resp = MaasServiceImpl.convertJsonBytesToTokenizeResp(response.getException().getMessage().getBytes());
            }
            catch (MaasException ignored) {
                throw new MaasException(response.getException(), response.getHttpCode(), req.getReqId());
            }
            throw new MaasException(resp.getError(), resp.getReqId());
        }
        return MaasServiceImpl.convertJsonBytesToTokenizeResp(response.getData());
    }

    @Override
    public Api.ClassificationResp classification(Api.ClassificationReq req) throws MaasException {
        RawResponse response = this.json("classification", null, MaasServiceImpl.json_dumps(req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            Api.ClassificationResp resp;
            try {
                resp = MaasServiceImpl.convertJsonBytesToClassificationResp(response.getException().getMessage().getBytes());
            }
            catch (MaasException ignored) {
                throw new MaasException(response.getException(), response.getHttpCode(), req.getReqId());
            }
            throw new MaasException(resp.getError(), resp.getReqId());
        }
        return MaasServiceImpl.convertJsonBytesToClassificationResp(response.getData());
    }

    @Override
    public Api.EmbeddingsResp embeddings(Api.EmbeddingsReq req) throws MaasException {
        RawResponse response = this.json("embeddings", null, MaasServiceImpl.json_dumps(req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            Api.EmbeddingsResp resp;
            try {
                resp = MaasServiceImpl.convertJsonBytesToEmbeddingsResp(response.getException().getMessage().getBytes());
            }
            catch (MaasException ignored) {
                throw new MaasException(response.getException(), response.getHttpCode(), req.getReqId());
            }
            throw new MaasException(resp.getError(), resp.getReqId());
        }
        return MaasServiceImpl.convertJsonBytesToEmbeddingsResp(response.getData());
    }

    private static Api.ChatResp convertJsonBytesToChatResp(byte[] data) throws MaasException {
        try {
            Api.ChatResp.Builder builder = Api.ChatResp.newBuilder();
            JsonFormat.parser().ignoringUnknownFields().merge(new String(data, StandardCharsets.UTF_8), (Message.Builder)builder);
            return builder.build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new MaasException((Exception)((Object)e), "");
        }
    }

    private static Api.TokenizeResp convertJsonBytesToTokenizeResp(byte[] data) throws MaasException {
        try {
            Api.TokenizeResp.Builder builder = Api.TokenizeResp.newBuilder();
            JsonFormat.parser().ignoringUnknownFields().merge(new String(data, StandardCharsets.UTF_8), (Message.Builder)builder);
            return builder.build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new MaasException((Exception)((Object)e), "");
        }
    }

    private static Api.ClassificationResp convertJsonBytesToClassificationResp(byte[] data) throws MaasException {
        try {
            Api.ClassificationResp.Builder builder = Api.ClassificationResp.newBuilder();
            JsonFormat.parser().ignoringUnknownFields().merge(new String(data, StandardCharsets.UTF_8), (Message.Builder)builder);
            return builder.build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new MaasException((Exception)((Object)e), "");
        }
    }

    private static Api.EmbeddingsResp convertJsonBytesToEmbeddingsResp(byte[] data) throws MaasException {
        try {
            Api.EmbeddingsResp.Builder builder = Api.EmbeddingsResp.newBuilder();
            JsonFormat.parser().ignoringUnknownFields().merge(new String(data, StandardCharsets.UTF_8), (Message.Builder)builder);
            return builder.build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new MaasException((Exception)((Object)e), "");
        }
    }

    private static <T extends GeneratedMessageV3> String json_dumps(T req) throws MaasException {
        try {
            return JsonFormat.printer().preservingProtoFieldNames().print(req);
        }
        catch (InvalidProtocolBufferException e) {
            throw new MaasException((Exception)((Object)e), "");
        }
    }

    private void closeInputStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

