/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.vpc.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.volcengine.vpc.model.TagFilterForListTagsForResourcesInput;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.NotNull;

public class ListTagsForResourcesRequest {
    @SerializedName(value="MaxResults")
    private Integer maxResults = null;
    @SerializedName(value="NextToken")
    private String nextToken = null;
    @SerializedName(value="ResourceIds")
    private List<String> resourceIds = null;
    @SerializedName(value="ResourceType")
    private ResourceTypeEnum resourceType = null;
    @SerializedName(value="TagFilters")
    private List<TagFilterForListTagsForResourcesInput> tagFilters = null;
    @SerializedName(value="TagType")
    private String tagType = null;

    public ListTagsForResourcesRequest maxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    @Max(value=100L)
    @Schema(description="")
    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public ListTagsForResourcesRequest nextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    @Schema(description="")
    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListTagsForResourcesRequest resourceIds(List<String> resourceIds) {
        this.resourceIds = resourceIds;
        return this;
    }

    public ListTagsForResourcesRequest addResourceIdsItem(String resourceIdsItem) {
        if (this.resourceIds == null) {
            this.resourceIds = new ArrayList<String>();
        }
        this.resourceIds.add(resourceIdsItem);
        return this;
    }

    @Schema(description="")
    public List<String> getResourceIds() {
        return this.resourceIds;
    }

    public void setResourceIds(List<String> resourceIds) {
        this.resourceIds = resourceIds;
    }

    public ListTagsForResourcesRequest resourceType(ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @NotNull
    @Schema(required=true, description="")
    public ResourceTypeEnum getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
    }

    public ListTagsForResourcesRequest tagFilters(List<TagFilterForListTagsForResourcesInput> tagFilters) {
        this.tagFilters = tagFilters;
        return this;
    }

    public ListTagsForResourcesRequest addTagFiltersItem(TagFilterForListTagsForResourcesInput tagFiltersItem) {
        if (this.tagFilters == null) {
            this.tagFilters = new ArrayList<TagFilterForListTagsForResourcesInput>();
        }
        this.tagFilters.add(tagFiltersItem);
        return this;
    }

    @Valid
    @Schema(description="")
    public List<TagFilterForListTagsForResourcesInput> getTagFilters() {
        return this.tagFilters;
    }

    public void setTagFilters(List<TagFilterForListTagsForResourcesInput> tagFilters) {
        this.tagFilters = tagFilters;
    }

    public ListTagsForResourcesRequest tagType(String tagType) {
        this.tagType = tagType;
        return this;
    }

    @Schema(description="")
    public String getTagType() {
        return this.tagType;
    }

    public void setTagType(String tagType) {
        this.tagType = tagType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListTagsForResourcesRequest listTagsForResourcesRequest = (ListTagsForResourcesRequest)o;
        return Objects.equals(this.maxResults, listTagsForResourcesRequest.maxResults) && Objects.equals(this.nextToken, listTagsForResourcesRequest.nextToken) && Objects.equals(this.resourceIds, listTagsForResourcesRequest.resourceIds) && Objects.equals((Object)this.resourceType, (Object)listTagsForResourcesRequest.resourceType) && Objects.equals(this.tagFilters, listTagsForResourcesRequest.tagFilters) && Objects.equals(this.tagType, listTagsForResourcesRequest.tagType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.maxResults, this.nextToken, this.resourceIds, this.resourceType, this.tagFilters, this.tagType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListTagsForResourcesRequest {\n");
        sb.append("    maxResults: ").append(this.toIndentedString(this.maxResults)).append("\n");
        sb.append("    nextToken: ").append(this.toIndentedString(this.nextToken)).append("\n");
        sb.append("    resourceIds: ").append(this.toIndentedString(this.resourceIds)).append("\n");
        sb.append("    resourceType: ").append(this.toIndentedString((Object)this.resourceType)).append("\n");
        sb.append("    tagFilters: ").append(this.toIndentedString(this.tagFilters)).append("\n");
        sb.append("    tagType: ").append(this.toIndentedString(this.tagType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ResourceTypeEnum {
        VPC("vpc"),
        ENI("eni"),
        SECURITYGROUP("securitygroup"),
        EIP("eip"),
        BANDWIDTHPACKAGE("bandwidthpackage"),
        VPNGATEWAY("vpngateway"),
        NGW("ngw"),
        DIRECTCONNECTCONNECTION("directconnectconnection"),
        DIRECTCONNECTGATEWAY("directconnectgateway"),
        DIRECTCONNECTVIRTUALINTERFACE("directconnectvirtualinterface");

        private String value;

        private ResourceTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ResourceTypeEnum fromValue(String input) {
            for (ResourceTypeEnum b : ResourceTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ResourceTypeEnum> {
            public void write(JsonWriter jsonWriter, ResourceTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ResourceTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ResourceTypeEnum.fromValue(value);
            }
        }
    }
}

