/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.registry.zookeeper;

import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.registry.NotifyListener;
import com.weibo.api.motan.registry.support.FailbackRegistry;
import com.weibo.api.motan.registry.zookeeper.ZkNodeType;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.LoggerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.ZkClient;

public class ZookeeperRegistry
extends FailbackRegistry {
    private ZkClient zkClient;
    private ConcurrentHashMap<URL, ConcurrentHashMap<NotifyListener, IZkChildListener>> urlListeners = new ConcurrentHashMap();

    public ZookeeperRegistry(URL url, ZkClient client) {
        super(url);
        this.zkClient = client;
    }

    public ConcurrentHashMap<URL, ConcurrentHashMap<NotifyListener, IZkChildListener>> getUrlListeners() {
        return this.urlListeners;
    }

    protected void doRegister(URL url) {
        try {
            this.removeNode(url, ZkNodeType.AVAILABLE_SERVER);
            this.removeNode(url, ZkNodeType.UNAVAILABLE_SERVER);
            this.createNode(url, ZkNodeType.UNAVAILABLE_SERVER);
        }
        catch (Throwable e) {
            throw new MotanFrameworkException(String.format("Failed to register %s to zookeeper(%s), cause: %s", url, this.getUrl(), e.getMessage()));
        }
    }

    protected void doUnregister(URL url) {
        try {
            this.removeNode(url, ZkNodeType.AVAILABLE_SERVER);
            this.removeNode(url, ZkNodeType.UNAVAILABLE_SERVER);
        }
        catch (Throwable e) {
            throw new MotanFrameworkException(String.format("Failed to unregister %s to zookeeper(%s), cause: %s", url, this.getUrl(), e.getMessage()));
        }
    }

    protected void doSubscribe(final URL url, final NotifyListener notifyListener) {
        try {
            IZkChildListener zkChildListener;
            ConcurrentHashMap<NotifyListener, IZkChildListener> childChangeListeners = this.urlListeners.get(url);
            if (childChangeListeners == null) {
                this.urlListeners.putIfAbsent(url, new ConcurrentHashMap());
                childChangeListeners = this.urlListeners.get(url);
            }
            if ((zkChildListener = childChangeListeners.get(notifyListener)) == null) {
                childChangeListeners.putIfAbsent(notifyListener, new IZkChildListener(){

                    public void handleChildChange(String parentPath, List<String> currentChilds) {
                        ZookeeperRegistry.this.notify(url, notifyListener, ZookeeperRegistry.this.nodeChildsToUrls(parentPath, currentChilds));
                        LoggerUtil.info((String)String.format("[ZookeeperRegistry] service list change: path=%s, currentChilds=%s", parentPath, currentChilds.toString()));
                    }
                });
                zkChildListener = childChangeListeners.get(notifyListener);
            }
            this.removeNode(url, ZkNodeType.CLIENT);
            this.createNode(url, ZkNodeType.CLIENT);
            String serverTypePath = this.toNodeTypePath(url, ZkNodeType.AVAILABLE_SERVER);
            List currentChilds = this.zkClient.subscribeChildChanges(serverTypePath, zkChildListener);
            LoggerUtil.info((String)String.format("[ZookeeperRegistry] subscribe: path=%s, info=%s", this.toNodePath(url, ZkNodeType.AVAILABLE_SERVER), url.toFullStr()));
            this.notify(url, notifyListener, this.nodeChildsToUrls(serverTypePath, currentChilds));
        }
        catch (Throwable e) {
            throw new MotanFrameworkException(String.format("Failed to subscribe %s to zookeeper(%s), cause: %s", url, this.getUrl(), e.getMessage()));
        }
    }

    protected void doUnsubscribe(URL url, NotifyListener notifyListener) {
        try {
            IZkChildListener zkChildListener;
            Map childChangeListeners = this.urlListeners.get(url);
            if (childChangeListeners != null && (zkChildListener = (IZkChildListener)childChangeListeners.get(notifyListener)) != null) {
                this.zkClient.unsubscribeChildChanges(this.toNodeTypePath(url, ZkNodeType.CLIENT), zkChildListener);
                childChangeListeners.remove(notifyListener);
            }
        }
        catch (Throwable e) {
            throw new MotanFrameworkException(String.format("Failed to unsubscribe %s to zookeeper(%s), cause: %s", url, this.getUrl(), e.getMessage()));
        }
    }

    protected List<URL> doDiscover(URL url) {
        try {
            String parentPath = this.toNodeTypePath(url, ZkNodeType.AVAILABLE_SERVER);
            List<String> currentChilds = new ArrayList<String>();
            if (this.zkClient.exists(parentPath)) {
                currentChilds = this.zkClient.getChildren(parentPath);
            }
            return this.nodeChildsToUrls(parentPath, currentChilds);
        }
        catch (Throwable e) {
            throw new MotanFrameworkException(String.format("Failed to discover %s from zookeeper(%s), cause: %s", url, this.getUrl(), e.getMessage()));
        }
    }

    protected void doAvailable(URL url) {
        if (url == null) {
            for (URL u : this.getRegisteredServiceUrls()) {
                this.removeNode(u, ZkNodeType.AVAILABLE_SERVER);
                this.removeNode(u, ZkNodeType.UNAVAILABLE_SERVER);
                this.createNode(u, ZkNodeType.AVAILABLE_SERVER);
            }
        } else {
            this.removeNode(url, ZkNodeType.AVAILABLE_SERVER);
            this.removeNode(url, ZkNodeType.UNAVAILABLE_SERVER);
            this.createNode(url, ZkNodeType.AVAILABLE_SERVER);
        }
    }

    protected void doUnavailable(URL url) {
        if (url == null) {
            for (URL u : this.getRegisteredServiceUrls()) {
                this.removeNode(u, ZkNodeType.AVAILABLE_SERVER);
                this.removeNode(u, ZkNodeType.UNAVAILABLE_SERVER);
                this.createNode(u, ZkNodeType.UNAVAILABLE_SERVER);
            }
        } else {
            this.removeNode(url, ZkNodeType.AVAILABLE_SERVER);
            this.removeNode(url, ZkNodeType.UNAVAILABLE_SERVER);
            this.createNode(url, ZkNodeType.UNAVAILABLE_SERVER);
        }
    }

    private List<URL> nodeChildsToUrls(String parentPath, List<String> currentChilds) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String node : currentChilds) {
            String nodePath = parentPath + "/" + node;
            String data = (String)this.zkClient.readData(nodePath, true);
            try {
                URL url = URL.valueOf((String)data);
                urls.add(url);
            }
            catch (Exception e) {
                LoggerUtil.warn((String)String.format("Found malformed urls from zookeeperRegistry, path=%s", nodePath), (Throwable)e);
            }
        }
        return urls;
    }

    private String toGroupPath(URL url) {
        return "/motan/" + url.getGroup();
    }

    private String toServicePath(URL url) {
        return this.toGroupPath(url) + "/" + url.getPath();
    }

    private String toNodeTypePath(URL url, ZkNodeType nodeType) {
        String type;
        if (nodeType == ZkNodeType.AVAILABLE_SERVER) {
            type = "server";
        } else if (nodeType == ZkNodeType.UNAVAILABLE_SERVER) {
            type = "unavailableServer";
        } else if (nodeType == ZkNodeType.CLIENT) {
            type = "client";
        } else {
            throw new MotanFrameworkException(String.format("Failed to get nodeTypePath, url: %s type: %s", url, nodeType.toString()));
        }
        return this.toServicePath(url) + "/" + type;
    }

    private String toNodePath(URL url, ZkNodeType nodeType) {
        return this.toNodeTypePath(url, nodeType) + "/" + url.getServerPortStr();
    }

    private void createNode(URL url, ZkNodeType nodeType) {
        String nodeTypePath = this.toNodeTypePath(url, nodeType);
        if (!this.zkClient.exists(nodeTypePath)) {
            this.zkClient.createPersistent(nodeTypePath, true);
        }
        this.zkClient.createEphemeral(this.toNodePath(url, nodeType), (Object)url.toFullStr());
    }

    private void removeNode(URL url, ZkNodeType nodeType) {
        String nodePath = this.toNodePath(url, nodeType);
        if (this.zkClient.exists(nodePath)) {
            this.zkClient.delete(nodePath);
        }
    }
}

