/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.config.springsupport;

import com.weibo.api.motan.config.BasicServiceInterfaceConfig;
import com.weibo.api.motan.config.RegistryConfig;
import com.weibo.api.motan.config.ServiceConfig;
import com.weibo.api.motan.config.springsupport.MotanNamespaceHandler;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.util.CollectionUtil;
import com.weibo.api.motan.util.MathUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class ServiceConfigBean<T>
extends ServiceConfig<T>
implements BeanPostProcessor,
BeanFactoryAware,
InitializingBean,
DisposableBean,
ApplicationListener<ContextRefreshedEvent> {
    private static final long serialVersionUID = -7247592395983804440L;
    private transient BeanFactory beanFactory;

    public void destroy() throws Exception {
        this.unexport();
    }

    public void afterPropertiesSet() throws Exception {
        this.checkAndConfigBasicConfig();
        this.checkAndConfigExport();
        this.checkAndConfigRegistry();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (!this.getExported().get()) {
            this.export();
        }
    }

    private void checkAndConfigBasicConfig() {
        if (this.getBasicServiceConfig() == null) {
            for (String name : MotanNamespaceHandler.basicServiceConfigDefineNames) {
                BasicServiceInterfaceConfig biConfig = (BasicServiceInterfaceConfig)this.beanFactory.getBean(name, BasicServiceInterfaceConfig.class);
                if (biConfig == null) continue;
                if (MotanNamespaceHandler.basicServiceConfigDefineNames.size() == 1) {
                    this.setBasicServiceConfig(biConfig);
                    continue;
                }
                if (biConfig.isDefault() == null || !biConfig.isDefault().booleanValue()) continue;
                this.setBasicServiceConfig(biConfig);
            }
        }
    }

    private void checkAndConfigExport() {
        int port;
        if (StringUtils.isBlank((CharSequence)this.getExport()) && this.getBasicServiceConfig() != null && !StringUtils.isBlank((CharSequence)this.getBasicServiceConfig().getExport())) {
            this.setExport(this.getBasicServiceConfig().getExport());
            if (this.getBasicServiceConfig().getProtocols() != null) {
                this.setProtocols(new ArrayList(this.getBasicServiceConfig().getProtocols()));
            }
        }
        if (CollectionUtil.isEmpty((Collection)this.getProtocols()) && StringUtils.isNotEmpty((CharSequence)this.getExport()) && (port = MathUtil.parseInt((String)this.export, (int)0)) > 0) {
            this.export = "motan:" + this.export;
            this.setProtocol(MotanFrameworkUtil.getDefaultProtocolConfig());
        }
        if (StringUtils.isEmpty((CharSequence)this.getExport()) || CollectionUtil.isEmpty((Collection)this.getProtocols())) {
            throw new MotanFrameworkException(String.format("%s ServiceConfig must config right export value!", this.getInterface().getName()), MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
        }
    }

    private void checkAndConfigRegistry() {
        if (CollectionUtil.isEmpty((Collection)this.getRegistries()) && this.getBasicServiceConfig() != null && !CollectionUtil.isEmpty((Collection)this.getBasicServiceConfig().getRegistries())) {
            this.setRegistries(this.getBasicServiceConfig().getRegistries());
        }
        if (CollectionUtil.isEmpty((Collection)this.getRegistries())) {
            for (String name : MotanNamespaceHandler.registryDefineNames) {
                RegistryConfig rc = (RegistryConfig)this.beanFactory.getBean(name, RegistryConfig.class);
                if (rc == null) continue;
                if (MotanNamespaceHandler.registryDefineNames.size() == 1) {
                    this.setRegistry(rc);
                    continue;
                }
                if (rc.isDefault() == null || !rc.isDefault().booleanValue()) continue;
                this.setRegistry(rc);
            }
        }
        if (CollectionUtil.isEmpty((Collection)this.getRegistries())) {
            this.setRegistry(MotanFrameworkUtil.getDefaultRegistryConfig());
        }
    }
}

