/*
 * Decompiled with CFR 0.152.
 */
package com.xiaochen.progressroundbutton;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.PathInterpolator;
import android.widget.LinearLayout;
import com.xiaochen.progressroundbutton.AnimDownloadProgressButton;
import com.xiaochen.progressroundbutton.ButtonController;
import com.xiaochen.progressroundbutton.R;

public class AnimButtonLayout
extends LinearLayout {
    private AnimDownloadProgressButton mDownloadProgressButton;
    private Drawable mShadowDrawable;
    private final int DEFAULT_COLOR = -7829368;
    private TimeInterpolator mInterpolator;
    private ValueAnimator mLayoutDownAnimator;
    private ValueAnimator mLayoutUpAnimator;
    private float mDensity;
    private float mCenterX;
    private float mCenterY;
    private int mLayoutWidth;
    private int mLayoutHeight;
    private float mCanvasScale = 1.0f;
    private final String PROPERTY_CANVAS_SCALE = "canvasScale";
    private final long ANIM_DOWN_DURATION = 128L;
    private final long ANIM_UP_DURATION = 352L;
    private float mTargetScale = 1.0f;
    private float mMinScale = 0.95f;

    public AnimButtonLayout(Context context) {
        super(context);
        this.mDownloadProgressButton = new AnimDownloadProgressButton(context);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -1);
        this.mDownloadProgressButton.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.addView((View)this.mDownloadProgressButton);
        this.init(context, null);
    }

    public AnimButtonLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
        this.mDownloadProgressButton = new AnimDownloadProgressButton(context, attrs);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -1);
        this.mDownloadProgressButton.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.addView((View)this.mDownloadProgressButton);
    }

    private void init(Context context, AttributeSet attributeSet) {
        this.mInterpolator = Build.VERSION.SDK_INT >= 21 ? new PathInterpolator(0.33f, 0.0f, 0.33f, 1.0f) : new AccelerateDecelerateInterpolator();
        this.mShadowDrawable = this.getResources().getDrawable(R.drawable.gradient_layout_shadow);
        this.mDensity = this.getResources().getDisplayMetrics().density;
    }

    protected void dispatchDraw(Canvas canvas) {
        canvas.save();
        canvas.scale(this.mCanvasScale, this.mCanvasScale, this.mCenterX, this.mCenterY);
        Log.w((String)"tan", (String)(this.mCanvasScale + ""));
        this.drawShadow(canvas);
        super.dispatchDraw(canvas);
        canvas.restore();
    }

    private void drawShadow(Canvas canvas) {
        if (this.mShadowDrawable == null) {
            return;
        }
        canvas.save();
        float scale = 1.0f - (1.0f - this.mCanvasScale) * 6.0f;
        canvas.scale(scale, scale, this.mCenterX, this.mCenterY);
        canvas.translate(0.0f, (this.mCanvasScale - 1.0f) * (float)this.mLayoutHeight * 6.0f + (float)this.mLayoutHeight * 0.4f + this.mDensity);
        this.mShadowDrawable.draw(canvas);
        canvas.restore();
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        if (!this.isEnabled()) {
            return false;
        }
        if (!this.isClickable()) {
            return false;
        }
        switch (action) {
            case 0: {
                this.handleActionDown(ev);
                Log.w((String)"tan", (String)"action down");
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                this.handleActionUp(ev);
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        Log.w((String)"tan", (String)"onsize change");
        this.mLayoutWidth = w;
        this.mLayoutHeight = h;
        this.mCenterX = this.mLayoutWidth / 2;
        this.mCenterY = this.mLayoutHeight / 2;
        if (this.mShadowDrawable == null) {
            return;
        }
        this.mShadowDrawable.setColorFilter(-7829368, PorterDuff.Mode.SRC_IN);
        this.mShadowDrawable.setBounds(0, 0, this.mLayoutWidth, this.mLayoutHeight);
        if (this.getParent() instanceof ViewGroup) {
            ((ViewGroup)this.getParent()).setClipChildren(false);
        }
    }

    private void handleActionDown(MotionEvent ev) {
        this.setupLayoutDownAnimator();
        this.mLayoutDownAnimator.start();
    }

    private void handleActionUp(MotionEvent ev) {
        this.setupLayoutUpAnimator();
        this.mLayoutUpAnimator.start();
    }

    private void setupLayoutDownAnimator() {
        this.mLayoutDownAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.95f});
        this.mLayoutDownAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                AnimButtonLayout.this.mCanvasScale = ((Float)animation.getAnimatedValue()).floatValue();
                AnimButtonLayout.this.invalidate();
            }
        });
        this.mLayoutDownAnimator.setInterpolator(this.mInterpolator);
        this.mLayoutDownAnimator.setDuration(128L);
    }

    private void setupLayoutUpAnimator() {
        this.mLayoutUpAnimator = ValueAnimator.ofFloat((float[])new float[]{0.95f, 1.0f});
        this.mLayoutUpAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                AnimButtonLayout.this.mCanvasScale = ((Float)animation.getAnimatedValue()).floatValue();
                AnimButtonLayout.this.invalidate();
            }
        });
        this.mLayoutUpAnimator.setInterpolator(this.mInterpolator);
        this.mLayoutUpAnimator.setDuration(352L);
    }

    public void invalidate() {
        super.invalidate();
        this.mDownloadProgressButton.invalidate();
    }

    public int getState() {
        return this.mDownloadProgressButton.getState();
    }

    public void setState(int state) {
        this.mDownloadProgressButton.setState(state);
    }

    public void setCurrentText(CharSequence charSequence) {
        this.mDownloadProgressButton.setCurrentText(charSequence);
    }

    public void setProgressText(String text, float progress) {
        this.mDownloadProgressButton.setProgressText(text, progress);
    }

    public float getProgress() {
        return this.mDownloadProgressButton.getProgress();
    }

    public void setProgress(float progress) {
        this.mDownloadProgressButton.setProgress(progress);
    }

    public void removeAllAnim() {
        this.mDownloadProgressButton.removeAllAnim();
    }

    public float getButtonRadius() {
        return this.mDownloadProgressButton.getButtonRadius();
    }

    public void setButtonRadius(float buttonRadius) {
        this.mDownloadProgressButton.setButtonRadius(buttonRadius);
    }

    public int getTextColor() {
        return this.mDownloadProgressButton.getTextColor();
    }

    public void setTextColor(int textColor) {
        this.mDownloadProgressButton.setTextColor(textColor);
    }

    public int getTextCoverColor() {
        return this.mDownloadProgressButton.getTextCoverColor();
    }

    public void setTextCoverColor(int textCoverColor) {
        this.mDownloadProgressButton.setTextCoverColor(textCoverColor);
    }

    public int getMinProgress() {
        return this.mDownloadProgressButton.getMinProgress();
    }

    public void setMinProgress(int minProgress) {
        this.mDownloadProgressButton.setMinProgress(minProgress);
    }

    public int getMaxProgress() {
        return this.mDownloadProgressButton.getMaxProgress();
    }

    public void setMaxProgress(int maxProgress) {
        this.mDownloadProgressButton.setMaxProgress(maxProgress);
    }

    public void enabelDefaultPress(boolean enable) {
        this.mDownloadProgressButton.enabelDefaultPress(enable);
    }

    public void enabelDefaultGradient(boolean enable) {
        this.mDownloadProgressButton.enabelDefaultGradient(enable);
    }

    public void setTextSize(float size) {
        this.mDownloadProgressButton.setTextSize(size);
    }

    public float getTextSize() {
        return this.mDownloadProgressButton.getTextSize();
    }

    public AnimDownloadProgressButton setCustomerController(ButtonController customerController) {
        return this.mDownloadProgressButton.setCustomerController(customerController);
    }
}

