/*
 * Decompiled with CFR 0.152.
 */
package com.xiaochen.progressroundbutton;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.animation.PathInterpolatorCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Interpolator;
import android.widget.TextView;
import com.xiaochen.progressroundbutton.ButtonController;
import com.xiaochen.progressroundbutton.DefaultButtonController;
import com.xiaochen.progressroundbutton.R;

public class AnimDownloadProgressButton
extends TextView {
    private Context mContext;
    private Paint mBackgroundPaint;
    private volatile Paint mTextPaint;
    private Paint mDot1Paint;
    private Paint mDot2Paint;
    private int[] mBackgroundColor;
    private int[] mOriginBackgroundColor;
    private int mBackgroundSecondColor;
    private int mTextColor;
    private int mTextCoverColor;
    private float mAboveTextSize = 50.0f;
    private float mProgress = -1.0f;
    private float mToProgress;
    private int mMaxProgress;
    private int mMinProgress;
    private float mProgressPercent;
    private float mButtonRadius;
    private float mDot1transX;
    private float mDot2transX;
    private RectF mBackgroundBounds;
    private LinearGradient mFillBgGradient;
    private LinearGradient mProgressBgGradient;
    private LinearGradient mProgressTextGradient;
    private AnimatorSet mDotAnimationSet;
    private ValueAnimator mProgressAnimation;
    private CharSequence mCurrentText;
    public static final int NORMAL = 0;
    public static final int DOWNLOADING = 1;
    public static final int INSTALLING = 2;
    private ButtonController mDefaultController;
    private ButtonController mCustomerController;
    private int mState;

    public AnimDownloadProgressButton(Context context) {
        this(context, null);
    }

    public AnimDownloadProgressButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (!this.isInEditMode()) {
            this.mContext = context;
            this.initController();
            this.initAttrs(context, attrs);
            this.init();
            this.setupAnimations();
        }
    }

    private void initController() {
        this.mDefaultController = new DefaultButtonController();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        ButtonController buttonController = this.switchController();
        if (buttonController.enablePress()) {
            if (this.mOriginBackgroundColor == null) {
                this.mOriginBackgroundColor = new int[2];
                this.mOriginBackgroundColor[0] = this.mBackgroundColor[0];
                this.mOriginBackgroundColor[1] = this.mBackgroundColor[1];
            }
            if (this.isPressed()) {
                int pressColorleft = buttonController.getPressedColor(this.mBackgroundColor[0]);
                int pressColorright = buttonController.getPressedColor(this.mBackgroundColor[1]);
                if (buttonController.enableGradient()) {
                    this.initGradientColor(pressColorleft, pressColorright);
                } else {
                    this.initGradientColor(pressColorleft, pressColorleft);
                }
            } else if (buttonController.enableGradient()) {
                this.initGradientColor(this.mOriginBackgroundColor[0], this.mOriginBackgroundColor[1]);
            } else {
                this.initGradientColor(this.mOriginBackgroundColor[0], this.mOriginBackgroundColor[0]);
            }
            this.invalidate();
        }
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AnimDownloadProgressButton);
        int bgColor = a.getColor(R.styleable.AnimDownloadProgressButton_progressbtn_backgroud_color, Color.parseColor((String)"#6699ff"));
        this.initGradientColor(bgColor, bgColor);
        this.mBackgroundSecondColor = a.getColor(R.styleable.AnimDownloadProgressButton_progressbtn_backgroud_second_color, -3355444);
        this.mButtonRadius = a.getFloat(R.styleable.AnimDownloadProgressButton_progressbtn_radius, (float)(this.getMeasuredHeight() / 2));
        this.mTextColor = a.getColor(R.styleable.AnimDownloadProgressButton_progressbtn_text_color, bgColor);
        this.mTextCoverColor = a.getColor(R.styleable.AnimDownloadProgressButton_progressbtn_text_covercolor, -1);
        boolean enableGradient = a.getBoolean(R.styleable.AnimDownloadProgressButton_progressbtn_enable_gradient, false);
        boolean enablePress = a.getBoolean(R.styleable.AnimDownloadProgressButton_progressbtn_enable_press, false);
        ((DefaultButtonController)this.mDefaultController).setEnableGradient(enableGradient).setEnablePress(enablePress);
        if (enableGradient) {
            this.initGradientColor(this.mDefaultController.getLighterColor(this.mBackgroundColor[0]), this.mBackgroundColor[0]);
        }
        a.recycle();
    }

    private void init() {
        this.mMaxProgress = 100;
        this.mMinProgress = 0;
        this.mProgress = 0.0f;
        this.mBackgroundPaint = new Paint();
        this.mBackgroundPaint.setAntiAlias(true);
        this.mBackgroundPaint.setStyle(Paint.Style.FILL);
        this.mTextPaint = new Paint();
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setTextSize(this.mAboveTextSize);
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, this.mTextPaint);
        }
        this.mDot1Paint = new Paint();
        this.mDot1Paint.setAntiAlias(true);
        this.mDot1Paint.setTextSize(50.0f);
        this.mDot2Paint = new Paint();
        this.mDot2Paint.setAntiAlias(true);
        this.mDot2Paint.setTextSize(50.0f);
        this.mState = 0;
        this.invalidate();
    }

    private int[] initGradientColor(int leftColor, int rightColor) {
        this.mBackgroundColor = new int[2];
        this.mBackgroundColor[0] = leftColor;
        this.mBackgroundColor[1] = rightColor;
        return this.mBackgroundColor;
    }

    private void setupAnimations() {
        ValueAnimator dotMoveAnimation = ValueAnimator.ofFloat((float[])new float[]{0.0f, 20.0f});
        Interpolator pathInterpolator = PathInterpolatorCompat.create((float)0.11f, (float)0.0f, (float)0.12f, (float)1.0f);
        dotMoveAnimation.setInterpolator((TimeInterpolator)pathInterpolator);
        dotMoveAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float transX = ((Float)animation.getAnimatedValue()).floatValue();
                AnimDownloadProgressButton.this.mDot1transX = transX;
                AnimDownloadProgressButton.this.mDot2transX = transX;
                AnimDownloadProgressButton.this.invalidate();
            }
        });
        dotMoveAnimation.setDuration(1243L);
        dotMoveAnimation.setRepeatMode(1);
        dotMoveAnimation.setRepeatCount(-1);
        final ValueAnimator dotAlphaAnim = ValueAnimator.ofInt((int[])new int[]{0, 1243}).setDuration(1243L);
        dotAlphaAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int time = (Integer)dotAlphaAnim.getAnimatedValue();
                int dot1Alpha = AnimDownloadProgressButton.this.calculateDot1AlphaByTime(time);
                int dot2Alpha = AnimDownloadProgressButton.this.calculateDot2AlphaByTime(time);
                AnimDownloadProgressButton.this.mDot1Paint.setColor(AnimDownloadProgressButton.this.mTextCoverColor);
                AnimDownloadProgressButton.this.mDot2Paint.setColor(AnimDownloadProgressButton.this.mTextCoverColor);
                AnimDownloadProgressButton.this.mDot1Paint.setAlpha(dot1Alpha);
                AnimDownloadProgressButton.this.mDot2Paint.setAlpha(dot2Alpha);
            }
        });
        dotAlphaAnim.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                AnimDownloadProgressButton.this.mDot1Paint.setAlpha(0);
                AnimDownloadProgressButton.this.mDot2Paint.setAlpha(0);
            }

            public void onAnimationEnd(Animator animation) {
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        dotAlphaAnim.setRepeatMode(1);
        dotAlphaAnim.setRepeatCount(-1);
        this.mDotAnimationSet = new AnimatorSet();
        this.mDotAnimationSet.playTogether(new Animator[]{dotAlphaAnim, dotMoveAnimation});
        this.mProgressAnimation = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f}).setDuration(500L);
        this.mProgressAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float timepercent = ((Float)animation.getAnimatedValue()).floatValue();
                AnimDownloadProgressButton.this.mProgress = (AnimDownloadProgressButton.this.mToProgress - AnimDownloadProgressButton.this.mProgress) * timepercent + AnimDownloadProgressButton.this.mProgress;
                AnimDownloadProgressButton.this.invalidate();
            }
        });
    }

    private int calculateDot2AlphaByTime(int time) {
        int alpha;
        if (0 <= time && time <= 83) {
            double DAlpha = 3.072289156626506 * (double)time;
            alpha = (int)DAlpha;
        } else if (83 < time && time <= 1000) {
            alpha = 255;
        } else if (1000 < time && time <= 1083) {
            double DAlpha = -3.072289156626506 * (double)(time - 1083);
            alpha = (int)DAlpha;
        } else {
            alpha = 1083 < time && time <= 1243 ? 0 : 255;
        }
        return alpha;
    }

    private int calculateDot1AlphaByTime(int time) {
        int alpha;
        if (0 <= time && time <= 160) {
            alpha = 0;
        } else if (160 < time && time <= 243) {
            double DAlpha = 3.072289156626506 * (double)(time - 160);
            alpha = (int)DAlpha;
        } else if (243 < time && time <= 1160) {
            alpha = 255;
        } else if (1160 < time && time <= 1243) {
            double DAlpha = -3.072289156626506 * (double)(time - 1243);
            alpha = (int)DAlpha;
        } else {
            alpha = 255;
        }
        return alpha;
    }

    private ValueAnimator createDotAlphaAnimation(int i, Paint mDot1Paint, int i1, int i2, int i3) {
        return new ValueAnimator();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.isInEditMode()) {
            this.drawing(canvas);
        }
    }

    private void drawing(Canvas canvas) {
        this.drawBackground(canvas);
        this.drawTextAbove(canvas);
    }

    private void drawBackground(Canvas canvas) {
        this.mBackgroundBounds = new RectF();
        if (this.mButtonRadius == 0.0f) {
            this.mButtonRadius = this.getMeasuredHeight() / 2;
        }
        this.mBackgroundBounds.left = 2.0f;
        this.mBackgroundBounds.top = 2.0f;
        this.mBackgroundBounds.right = this.getMeasuredWidth() - 2;
        this.mBackgroundBounds.bottom = this.getMeasuredHeight() - 2;
        ButtonController buttonController = this.switchController();
        switch (this.mState) {
            case 0: {
                if (buttonController.enableGradient()) {
                    this.mFillBgGradient = new LinearGradient(0.0f, (float)(this.getMeasuredHeight() / 2), (float)this.getMeasuredWidth(), (float)(this.getMeasuredHeight() / 2), this.mBackgroundColor, null, Shader.TileMode.CLAMP);
                    this.mBackgroundPaint.setShader((Shader)this.mFillBgGradient);
                } else {
                    if (this.mBackgroundPaint.getShader() != null) {
                        this.mBackgroundPaint.setShader(null);
                    }
                    this.mBackgroundPaint.setColor(this.mBackgroundColor[0]);
                }
                canvas.drawRoundRect(this.mBackgroundBounds, this.mButtonRadius, this.mButtonRadius, this.mBackgroundPaint);
                break;
            }
            case 1: {
                if (buttonController.enableGradient()) {
                    this.mProgressPercent = this.mProgress / ((float)this.mMaxProgress + 0.0f);
                    int[] colorList = new int[]{this.mBackgroundColor[0], this.mBackgroundColor[1], this.mBackgroundSecondColor};
                    this.mProgressBgGradient = new LinearGradient(0.0f, 0.0f, (float)this.getMeasuredWidth(), 0.0f, colorList, new float[]{0.0f, this.mProgressPercent, this.mProgressPercent + 0.001f}, Shader.TileMode.CLAMP);
                    this.mBackgroundPaint.setShader((Shader)this.mProgressBgGradient);
                } else {
                    this.mProgressPercent = this.mProgress / ((float)this.mMaxProgress + 0.0f);
                    this.mProgressBgGradient = new LinearGradient(0.0f, 0.0f, (float)this.getMeasuredWidth(), 0.0f, new int[]{this.mBackgroundColor[0], this.mBackgroundSecondColor}, new float[]{this.mProgressPercent, this.mProgressPercent + 0.001f}, Shader.TileMode.CLAMP);
                    this.mBackgroundPaint.setColor(this.mBackgroundColor[0]);
                    this.mBackgroundPaint.setShader((Shader)this.mProgressBgGradient);
                }
                canvas.drawRoundRect(this.mBackgroundBounds, this.mButtonRadius, this.mButtonRadius, this.mBackgroundPaint);
                break;
            }
            case 2: {
                if (buttonController.enableGradient()) {
                    this.mFillBgGradient = new LinearGradient(0.0f, (float)(this.getMeasuredHeight() / 2), (float)this.getMeasuredWidth(), (float)(this.getMeasuredHeight() / 2), this.mBackgroundColor, null, Shader.TileMode.CLAMP);
                    this.mBackgroundPaint.setShader((Shader)this.mFillBgGradient);
                } else {
                    this.mBackgroundPaint.setShader(null);
                    this.mBackgroundPaint.setColor(this.mBackgroundColor[0]);
                }
                canvas.drawRoundRect(this.mBackgroundBounds, this.mButtonRadius, this.mButtonRadius, this.mBackgroundPaint);
            }
        }
    }

    private void drawTextAbove(Canvas canvas) {
        float y = (float)(canvas.getHeight() / 2) - (this.mTextPaint.descent() / 2.0f + this.mTextPaint.ascent() / 2.0f);
        if (this.mCurrentText == null) {
            this.mCurrentText = "";
        }
        float textWidth = this.mTextPaint.measureText(this.mCurrentText.toString());
        switch (this.mState) {
            case 0: {
                this.mTextPaint.setShader(null);
                this.mTextPaint.setColor(this.mTextCoverColor);
                canvas.drawText(this.mCurrentText.toString(), ((float)this.getMeasuredWidth() - textWidth) / 2.0f, y, this.mTextPaint);
                break;
            }
            case 1: {
                float coverlength = (float)this.getMeasuredWidth() * this.mProgressPercent;
                float indicator1 = (float)(this.getMeasuredWidth() / 2) - textWidth / 2.0f;
                float indicator2 = (float)(this.getMeasuredWidth() / 2) + textWidth / 2.0f;
                float coverTextLength = textWidth / 2.0f - (float)(this.getMeasuredWidth() / 2) + coverlength;
                float textProgress = coverTextLength / textWidth;
                if (coverlength <= indicator1) {
                    this.mTextPaint.setShader(null);
                    this.mTextPaint.setColor(this.mTextColor);
                } else if (indicator1 < coverlength && coverlength <= indicator2) {
                    this.mProgressTextGradient = new LinearGradient(((float)this.getMeasuredWidth() - textWidth) / 2.0f, 0.0f, ((float)this.getMeasuredWidth() + textWidth) / 2.0f, 0.0f, new int[]{this.mTextCoverColor, this.mTextColor}, new float[]{textProgress, textProgress + 0.001f}, Shader.TileMode.CLAMP);
                    this.mTextPaint.setColor(this.mTextColor);
                    this.mTextPaint.setShader((Shader)this.mProgressTextGradient);
                } else {
                    this.mTextPaint.setShader(null);
                    this.mTextPaint.setColor(this.mTextCoverColor);
                }
                canvas.drawText(this.mCurrentText.toString(), ((float)this.getMeasuredWidth() - textWidth) / 2.0f, y, this.mTextPaint);
                break;
            }
            case 2: {
                this.mTextPaint.setColor(this.mTextCoverColor);
                canvas.drawText(this.mCurrentText.toString(), ((float)this.getMeasuredWidth() - textWidth) / 2.0f, y, this.mTextPaint);
                canvas.drawCircle(((float)this.getMeasuredWidth() + textWidth) / 2.0f + 4.0f + this.mDot1transX, y, 4.0f, this.mDot1Paint);
                canvas.drawCircle(((float)this.getMeasuredWidth() + textWidth) / 2.0f + 24.0f + this.mDot2transX, y, 4.0f, this.mDot2Paint);
            }
        }
    }

    private ButtonController switchController() {
        if (this.mCustomerController != null) {
            return this.mCustomerController;
        }
        return this.mDefaultController;
    }

    public int getState() {
        return this.mState;
    }

    public void setState(int state) {
        if (this.mState != state) {
            this.mState = state;
            this.invalidate();
            if (state == 2) {
                this.mDotAnimationSet.start();
            } else if (state == 0) {
                this.mDotAnimationSet.cancel();
            } else if (state == 1) {
                this.mDotAnimationSet.cancel();
            }
        }
    }

    public void setCurrentText(CharSequence charSequence) {
        this.mCurrentText = charSequence;
        this.invalidate();
    }

    @TargetApi(value=19)
    public void setProgressText(String text, float progress) {
        if (progress >= (float)this.mMinProgress && progress < (float)this.mMaxProgress) {
            this.mCurrentText = text + this.getResources().getString(R.string.downloaded, new Object[]{(int)progress});
            this.mToProgress = progress;
            if (this.mProgressAnimation.isRunning()) {
                this.mProgressAnimation.start();
            } else {
                this.mProgressAnimation.start();
            }
        } else if (progress < (float)this.mMinProgress) {
            this.mProgress = 0.0f;
        } else if (progress >= (float)this.mMaxProgress) {
            this.mProgress = 100.0f;
            this.mCurrentText = text + this.getResources().getString(R.string.downloaded, new Object[]{(int)this.mProgress});
            this.invalidate();
        }
    }

    public float getProgress() {
        return this.mProgress;
    }

    public void setProgress(float progress) {
        this.mProgress = progress;
    }

    public void removeAllAnim() {
        this.mDotAnimationSet.cancel();
        this.mDotAnimationSet.removeAllListeners();
        this.mProgressAnimation.cancel();
        this.mProgressAnimation.removeAllListeners();
    }

    public float getButtonRadius() {
        return this.mButtonRadius;
    }

    public void setButtonRadius(float buttonRadius) {
        this.mButtonRadius = buttonRadius;
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public void setTextColor(int textColor) {
        this.mTextColor = textColor;
    }

    public int getTextCoverColor() {
        return this.mTextCoverColor;
    }

    public void setTextCoverColor(int textCoverColor) {
        this.mTextCoverColor = textCoverColor;
    }

    public int getMinProgress() {
        return this.mMinProgress;
    }

    public void setMinProgress(int minProgress) {
        this.mMinProgress = minProgress;
    }

    public int getMaxProgress() {
        return this.mMaxProgress;
    }

    public void setMaxProgress(int maxProgress) {
        this.mMaxProgress = maxProgress;
    }

    public void enabelDefaultPress(boolean enable) {
        if (this.mDefaultController != null) {
            ((DefaultButtonController)this.mDefaultController).setEnablePress(enable);
        }
    }

    public void enabelDefaultGradient(boolean enable) {
        if (this.mDefaultController != null) {
            ((DefaultButtonController)this.mDefaultController).setEnableGradient(enable);
            this.initGradientColor(this.mDefaultController.getLighterColor(this.mBackgroundColor[0]), this.mBackgroundColor[0]);
        }
    }

    public void setTextSize(float size) {
        this.mAboveTextSize = size;
        this.mTextPaint.setTextSize(size);
    }

    public float getTextSize() {
        return this.mAboveTextSize;
    }

    public AnimDownloadProgressButton setCustomerController(ButtonController customerController) {
        this.mCustomerController = customerController;
        return this;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mState = ss.state;
        this.mProgress = ss.progress;
        this.mCurrentText = ss.currentText;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, (int)this.mProgress, this.mState, this.mCurrentText.toString());
    }

    public static class SavedState
    extends View.BaseSavedState {
        private int progress;
        private int state;
        private String currentText;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable parcel, int progress, int state, String currentText) {
            super(parcel);
            this.progress = progress;
            this.state = state;
            this.currentText = currentText;
        }

        private SavedState(Parcel in) {
            super(in);
            this.progress = in.readInt();
            this.state = in.readInt();
            this.currentText = in.readString();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.progress);
            out.writeInt(this.state);
            out.writeString(this.currentText);
        }
    }
}

