/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.auth;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.yammer.dropwizard.auth.AuthenticationException;
import com.yammer.dropwizard.auth.Authenticator;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class CachingAuthenticator<C, P>
implements Authenticator<C, P> {
    private final Authenticator<C, P> underlying;
    private final LoadingCache<C, Optional<P>> cache;
    private final Meter cacheMisses;
    private final Timer gets;

    public static <C, P> CachingAuthenticator<C, P> wrap(Authenticator<C, P> authenticator, CacheBuilderSpec cacheSpec) {
        return new CachingAuthenticator<C, P>(authenticator, (CacheBuilder<Object, Object>)CacheBuilder.from((CacheBuilderSpec)cacheSpec));
    }

    private CachingAuthenticator(Authenticator<C, P> authenticator, CacheBuilder<Object, Object> builder) {
        this.underlying = authenticator;
        this.cacheMisses = Metrics.newMeter(authenticator.getClass(), (String)"cache-misses", (String)"lookups", (TimeUnit)TimeUnit.SECONDS);
        this.gets = Metrics.newTimer(authenticator.getClass(), (String)"gets", (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.SECONDS);
        this.cache = builder.recordStats().build(new CacheLoader<C, Optional<P>>(){

            public Optional<P> load(C key) throws Exception {
                CachingAuthenticator.this.cacheMisses.mark();
                return CachingAuthenticator.this.underlying.authenticate(key);
            }
        });
    }

    @Override
    public Optional<P> authenticate(C credentials) throws AuthenticationException {
        TimerContext context = this.gets.time();
        try {
            Optional optional = (Optional)this.cache.get(credentials);
            return optional;
        }
        catch (ExecutionException e) {
            throw new AuthenticationException(e);
        }
        finally {
            context.stop();
        }
    }

    public void invalidate(C credentials) {
        this.cache.invalidate(credentials);
    }

    public void invalidateAll(Iterable<C> credentials) {
        this.cache.invalidateAll(credentials);
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    public long size() {
        return this.cache.size();
    }

    public CacheStats stats() {
        return this.cache.stats();
    }
}

