/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.auth.basic;

import com.google.common.base.Optional;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.server.impl.inject.AbstractHttpContextInjectable;
import com.yammer.dropwizard.auth.AuthenticationException;
import com.yammer.dropwizard.auth.Authenticator;
import com.yammer.dropwizard.auth.basic.BasicAuthProvider;
import com.yammer.dropwizard.auth.basic.BasicCredentials;
import java.io.UnsupportedEncodingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.eclipse.jetty.util.B64Code;

class BasicAuthInjectable<T>
extends AbstractHttpContextInjectable<T> {
    private static final String PREFIX = "Basic";
    private static final String HEADER_NAME = "WWW-Authenticate";
    private static final String HEADER_VALUE = "Basic realm=\"%s\"";
    private final Authenticator<BasicCredentials, T> authenticator;
    private final String realm;
    private final boolean required;

    BasicAuthInjectable(Authenticator<BasicCredentials, T> authenticator, String realm, boolean required) {
        this.authenticator = authenticator;
        this.realm = realm;
        this.required = required;
    }

    public Authenticator<BasicCredentials, T> getAuthenticator() {
        return this.authenticator;
    }

    public String getRealm() {
        return this.realm;
    }

    public boolean isRequired() {
        return this.required;
    }

    public T getValue(HttpContext c) {
        String header = c.getRequest().getHeaderValue("Authorization");
        try {
            String password;
            String username;
            BasicCredentials credentials;
            Optional<T> result;
            String decoded;
            int i;
            String method;
            int space;
            if (header != null && (space = header.indexOf(32)) > 0 && PREFIX.equalsIgnoreCase(method = header.substring(0, space)) && (i = (decoded = B64Code.decode((String)header.substring(space + 1), (String)"ISO-8859-1")).indexOf(58)) > 0 && (result = this.authenticator.authenticate(credentials = new BasicCredentials(username = decoded.substring(0, i), password = decoded.substring(i + 1)))).isPresent()) {
                return (T)result.get();
            }
        }
        catch (UnsupportedEncodingException e) {
            BasicAuthProvider.LOG.debug((Throwable)e, "Error decoding credentials", new Object[0]);
        }
        catch (IllegalArgumentException e) {
            BasicAuthProvider.LOG.debug((Throwable)e, "Error decoding credentials", new Object[0]);
        }
        catch (AuthenticationException e) {
            BasicAuthProvider.LOG.warn((Throwable)e, "Error authenticating credentials", new Object[0]);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (this.required) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).header(HEADER_NAME, (Object)String.format(HEADER_VALUE, this.realm)).entity((Object)"Credentials are required to access this resource.").type(MediaType.TEXT_PLAIN_TYPE).build());
        }
        return null;
    }
}

