/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.auth.oauth;

import com.google.common.base.Optional;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.server.impl.inject.AbstractHttpContextInjectable;
import com.yammer.dropwizard.auth.AuthenticationException;
import com.yammer.dropwizard.auth.Authenticator;
import com.yammer.dropwizard.logging.Log;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

class OAuthInjectable<T>
extends AbstractHttpContextInjectable<T> {
    private static final Log LOG = Log.forClass(OAuthInjectable.class);
    private static final String HEADER_NAME = "WWW-Authenticate";
    private static final String HEADER_VALUE = "Bearer realm=\"%s\"";
    private static final String PREFIX = "bearer";
    private final Authenticator<String, T> authenticator;
    private final String realm;
    private final boolean required;

    OAuthInjectable(Authenticator<String, T> authenticator, String realm, boolean required) {
        this.authenticator = authenticator;
        this.realm = realm;
        this.required = required;
    }

    public Authenticator<String, T> getAuthenticator() {
        return this.authenticator;
    }

    public String getRealm() {
        return this.realm;
    }

    public boolean isRequired() {
        return this.required;
    }

    public T getValue(HttpContext c) {
        try {
            String credentials;
            Optional<T> result;
            String method;
            int space;
            String header = c.getRequest().getHeaderValue("Authorization");
            if (header != null && (space = header.indexOf(32)) > 0 && PREFIX.equalsIgnoreCase(method = header.substring(0, space)) && (result = this.authenticator.authenticate(credentials = header.substring(space + 1))).isPresent()) {
                return (T)result.get();
            }
        }
        catch (AuthenticationException e) {
            LOG.warn((Throwable)e, "Error authenticating credentials", new Object[0]);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (this.required) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).header(HEADER_NAME, (Object)String.format(HEADER_VALUE, this.realm)).entity((Object)"Credentials are required to access this resource.").type(MediaType.TEXT_PLAIN_TYPE).build());
        }
        return null;
    }
}

