/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.testing;

import com.yammer.dropwizard.json.Json;
import com.yammer.dropwizard.testing.FixtureHelpers;
import java.io.IOException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.type.TypeReference;

public class JsonHelpers {
    private static final Json JSON = new Json();

    private JsonHelpers() {
    }

    public static String asJson(Object object) throws IllegalArgumentException {
        return JSON.writeValueAsString(object);
    }

    public static <T> T fromJson(String json, Class<T> klass) throws IOException {
        return (T)JSON.readValue(json, klass);
    }

    public static <T> T fromJson(String json, TypeReference<T> reference) throws IOException {
        return (T)JSON.readValue(json, reference);
    }

    public static String jsonFixture(String filename) throws IOException {
        return JSON.writeValueAsString(JSON.readValue(FixtureHelpers.fixture(filename), JsonNode.class));
    }
}

