/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.testing;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.JerseyTest;
import com.sun.jersey.test.framework.LowLevelAppDescriptor;
import com.yammer.dropwizard.bundles.JavaBundle;
import com.yammer.dropwizard.jersey.DropwizardResourceConfig;
import com.yammer.dropwizard.jersey.JacksonMessageBodyProvider;
import com.yammer.dropwizard.json.Json;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.map.Module;
import org.junit.After;
import org.junit.Before;

public abstract class ResourceTest {
    private final Set<Object> singletons = Sets.newHashSet();
    private final Set<Class<?>> providers = Sets.newHashSet();
    private final List<Module> modules = Lists.newArrayList();
    private final Map<String, Boolean> features = Maps.newHashMap();
    private JerseyTest test;

    protected abstract void setUpResources() throws Exception;

    protected void addResource(Object resource) {
        this.singletons.add(resource);
    }

    public void addProvider(Class<?> klass) {
        this.providers.add(klass);
    }

    protected void addJacksonModule(Module module) {
        this.modules.add(module);
    }

    protected void addFeature(String feature, Boolean value) {
        this.features.put(feature, value);
    }

    protected Json getJson() {
        Json json = new Json();
        for (Module module : this.modules) {
            json.registerModule(module);
        }
        return json;
    }

    protected Client client() {
        return this.test.client();
    }

    @Before
    public void setUpJersey() throws Exception {
        this.setUpResources();
        this.test = new JerseyTest(){

            protected AppDescriptor configure() {
                DropwizardResourceConfig config = new DropwizardResourceConfig(true);
                for (Object provider : JavaBundle.DEFAULT_PROVIDERS) {
                    config.getSingletons().add(provider);
                }
                for (Object provider : ResourceTest.this.providers) {
                    config.getClasses().add(provider);
                }
                Json json = ResourceTest.this.getJson();
                for (Map.Entry feature : ResourceTest.this.features.entrySet()) {
                    config.getFeatures().put(feature.getKey(), feature.getValue());
                }
                config.getSingletons().add(new JacksonMessageBodyProvider(json));
                config.getSingletons().addAll(ResourceTest.this.singletons);
                return new LowLevelAppDescriptor.Builder((ResourceConfig)config).build();
            }
        };
        this.test.setUp();
    }

    @After
    public void tearDownJersey() throws Exception {
        if (this.test != null) {
            this.test.tearDown();
        }
    }
}

