/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.views;

import com.google.common.base.Charsets;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.sun.jersey.api.container.ContainerException;
import com.yammer.dropwizard.views.View;
import com.yammer.metrics.core.TimerContext;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@Produces(value={"text/html", "application/xhtml+xml"})
public class ViewMessageBodyWriter
implements MessageBodyWriter<View> {
    private static final String MISSING_TEMPLATE_MSG = "<html><head><title>Missing Template</title></head><body><h1>Missing Template</h1><p>{0}</p></body></html>";
    private final LoadingCache<Class<?>, Configuration> configurationCache;
    @Context
    private HttpHeaders headers;

    public ViewMessageBodyWriter() {
        this(null);
    }

    public ViewMessageBodyWriter(HttpHeaders headers) {
        this.headers = headers;
        this.configurationCache = CacheBuilder.newBuilder().concurrencyLevel(128).build((CacheLoader)new TemplateLoader());
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return View.class.isAssignableFrom(type);
    }

    public long getSize(View t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(View t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        TimerContext context = t.getRenderingTimer().time();
        try {
            Configuration configuration = (Configuration)this.configurationCache.getUnchecked(type);
            Template template = configuration.getTemplate(t.getTemplateName(), this.detectLocale(this.headers));
            template.process((Object)t, (Writer)new OutputStreamWriter(entityStream, template.getEncoding()));
        }
        catch (TemplateException e) {
            throw new ContainerException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            String msg = MessageFormat.format(MISSING_TEMPLATE_MSG, e.getMessage());
            throw new WebApplicationException(Response.serverError().type(MediaType.TEXT_HTML_TYPE).entity((Object)msg).build());
        }
        finally {
            context.stop();
        }
    }

    private Locale detectLocale(HttpHeaders headers) {
        List languages = headers.getAcceptableLanguages();
        for (Locale locale : languages) {
            if (locale.toString().contains("*")) continue;
            return locale;
        }
        return Locale.getDefault();
    }

    private static class TemplateLoader
    extends CacheLoader<Class<?>, Configuration> {
        private TemplateLoader() {
        }

        public Configuration load(Class<?> key) throws Exception {
            Configuration configuration = new Configuration();
            configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            configuration.setDefaultEncoding(Charsets.UTF_8.name());
            configuration.setClassForTemplateLoading(key, "/");
            return configuration;
        }
    }
}

