/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.album.fragment;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import com.yanzhenjie.album.R;
import com.yanzhenjie.album.util.AlbumUtils;
import com.yanzhenjie.alertdialog.AlertDialog;
import com.yanzhenjie.fragment.NoFragment;
import java.io.File;

abstract class BasicCameraFragment
extends NoFragment {
    private static final String INSTANCE_CAMERA_FILE_PATH = "INSTANCE_CAMERA_FILE_PATH";
    private static final int PERMISSION_REQUEST_CAMERA = 300;
    private static final int REQUEST_CODE_ACTIVITY_CAMERA = 300;
    private String mCameraFilePath;

    BasicCameraFragment() {
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putString(INSTANCE_CAMERA_FILE_PATH, this.mCameraFilePath);
        super.onSaveInstanceState(outState);
    }

    protected void cameraUnKnowPermission() {
        if (Build.VERSION.SDK_INT >= 23) {
            int permissionResult = ContextCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.CAMERA");
            if (permissionResult == 0) {
                this.cameraWithPermission();
            } else if (permissionResult == -1) {
                this.requestPermissions(new String[]{"android.permission.CAMERA"}, 300);
            }
        } else {
            this.cameraWithPermission();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        switch (requestCode) {
            case 300: {
                int permissionResult = grantResults[0];
                if (permissionResult == 0) {
                    this.cameraWithPermission();
                    break;
                }
                AlertDialog.build((Context)this.getContext()).setTitle(R.string.album_dialog_permission_failed).setMessage(R.string.album_permission_camera_failed_hint).setPositiveButton(R.string.album_dialog_sure, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                    }
                }).show();
                break;
            }
        }
    }

    private void cameraWithPermission() {
        String outFileFolder = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM).getAbsolutePath();
        String outFilePath = AlbumUtils.getNowDateTime("yyyyMMdd_HHmmssSSS") + ".jpg";
        File file = new File(outFileFolder, outFilePath);
        this.mCameraFilePath = file.getAbsolutePath();
        AlbumUtils.startCamera((Fragment)this, 300, file);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 300 && resultCode == -1) {
            this.onCameraBack(this.mCameraFilePath);
        }
    }

    protected abstract void onCameraBack(String var1);
}

