/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.album.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.AppCompatCheckBox;
import android.support.v7.widget.Toolbar;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.yanzhenjie.album.R;
import com.yanzhenjie.album.adapter.PathPreviewAdapter;
import com.yanzhenjie.album.util.SelectorUtils;
import com.yanzhenjie.fragment.NoFragment;
import java.util.ArrayList;
import java.util.List;

public class GalleryFragment
extends NoFragment {
    private Callback mCallback;
    private int mToolBarColor;
    private MenuItem mFinishMenuItem;
    private View mCheckParent;
    private AppCompatCheckBox mCheckBox;
    private int mCurrentItemPosition;
    private ViewPager mViewPager;
    private List<String> mCheckedPaths;
    private boolean[] mCheckedList;

    public void onAttach(Context context) {
        super.onAttach(context);
        this.mCallback = (Callback)context;
    }

    public void onDetach() {
        super.onDetach();
        this.mCallback = null;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.album_fragment_preview, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        this.mCheckParent = view.findViewById(R.id.layout_gallery_preview_bottom);
        this.mCheckBox = (AppCompatCheckBox)view.findViewById(R.id.cb_album_check);
        this.mViewPager = (ViewPager)view.findViewById(R.id.view_pager);
        this.setToolbar((Toolbar)view.findViewById(R.id.toolbar));
        this.displayHomeAsUpEnabled(R.drawable.album_ic_back_white);
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        boolean hasCheck;
        super.onActivityCreated(savedInstanceState);
        Bundle argument = this.getArguments();
        this.mToolBarColor = argument.getInt("KEY_INPUT_TOOLBAR_COLOR", ContextCompat.getColor((Context)this.getContext(), (int)R.color.albumColorPrimary));
        this.getToolbar().setBackgroundColor(this.mToolBarColor);
        this.getToolbar().getBackground().mutate().setAlpha(200);
        this.mCurrentItemPosition = argument.getInt("KEY_INPUT_CURRENT_POSITION", 0);
        if (this.mCurrentItemPosition >= this.mCheckedPaths.size()) {
            this.mCurrentItemPosition = 0;
        }
        if (!(hasCheck = argument.getBoolean("KEY_INPUT_CHECK_FUNCTION", false))) {
            this.mCheckParent.setVisibility(8);
        }
        this.initializeCheckBox();
        this.initializeViewPager();
        this.setCheckedCountUI(this.getCheckCount());
    }

    public void bindImagePaths(List<String> imagePaths) {
        this.mCheckedPaths = imagePaths;
        int length = this.mCheckedPaths.size();
        this.mCheckedList = new boolean[length];
        for (int i = 0; i < length; ++i) {
            this.mCheckedList[i] = true;
        }
    }

    private void initializeCheckBox() {
        this.mCheckBox.setSupportButtonTintList(SelectorUtils.createColorStateList(-1, this.mToolBarColor));
        this.mCheckBox.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                boolean isChecked;
                ((GalleryFragment)GalleryFragment.this).mCheckedList[((GalleryFragment)GalleryFragment.this).mCurrentItemPosition] = isChecked = GalleryFragment.this.mCheckBox.isChecked();
                GalleryFragment.this.setCheckedCountUI(GalleryFragment.this.getCheckCount());
            }
        });
    }

    private void initializeViewPager() {
        if (this.mCheckedPaths.size() > 2) {
            this.mViewPager.setOffscreenPageLimit(2);
        }
        PathPreviewAdapter previewAdapter = new PathPreviewAdapter(this.mCheckedPaths);
        this.mViewPager.setAdapter((PagerAdapter)previewAdapter);
        ViewPager.SimpleOnPageChangeListener pageChangeListener = new ViewPager.SimpleOnPageChangeListener(){

            public void onPageSelected(int position) {
                GalleryFragment.this.mCurrentItemPosition = position;
                GalleryFragment.this.mCheckBox.setChecked(GalleryFragment.this.mCheckedList[position]);
                GalleryFragment.this.getToolbar().setTitle((CharSequence)(GalleryFragment.this.mCurrentItemPosition + 1 + " / " + GalleryFragment.this.mCheckedPaths.size()));
            }
        };
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)pageChangeListener);
        this.mViewPager.setCurrentItem(this.mCurrentItemPosition);
        pageChangeListener.onPageSelected(this.mCurrentItemPosition);
    }

    private void setCheckedCountUI(int count) {
        String finishStr = this.getString(R.string.album_menu_finish);
        finishStr = finishStr + "(" + count + " / " + this.mCheckedPaths.size() + ")";
        this.mFinishMenuItem.setTitle((CharSequence)finishStr);
    }

    private int getCheckCount() {
        int i = 0;
        for (boolean b : this.mCheckedList) {
            if (!b) continue;
            ++i;
        }
        return i;
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        inflater.inflate(R.menu.album_menu_preview, menu2);
        this.mFinishMenuItem = menu2.findItem(R.id.album_menu_finish);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int itemId = item.getItemId();
        if (itemId == R.id.album_menu_finish) {
            ArrayList<String> patList = new ArrayList<String>();
            for (int i = 0; i < this.mCheckedList.length; ++i) {
                if (!this.mCheckedList[i]) continue;
                patList.add(this.mCheckedPaths.get(i));
            }
            this.mCallback.onGalleryCallback(patList);
        }
        return true;
    }

    public static interface Callback {
        public void onGalleryCallback(ArrayList<String> var1);
    }
}

