/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.album.task;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.media.ExifInterface;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.util.LruCache;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.yanzhenjie.album.impl.AlbumImageLoader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class LocalImageLoader
implements AlbumImageLoader {
    public static final Drawable DEFAULT_DRAWABLE = new ColorDrawable(Color.parseColor((String)"#FF2B2B2B"));
    private static LocalImageLoader mInstance;
    private static Handler instanceHandler;
    private final LruCache<String, Bitmap> mLruCache;
    private final ExecutorService mExecutorService = Executors.newFixedThreadPool(6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocalImageLoader getInstance() {
        if (mInstance != null) return mInstance;
        Class<LocalImageLoader> clazz = LocalImageLoader.class;
        synchronized (LocalImageLoader.class) {
            if (mInstance != null) return mInstance;
            mInstance = new LocalImageLoader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public LocalImageLoader() {
        int maxMemory = (int)(Runtime.getRuntime().maxMemory() / 4L);
        this.mLruCache = new LruCache<String, Bitmap>(maxMemory){

            protected int sizeOf(String key, Bitmap value) {
                return value.getRowBytes() * value.getHeight();
            }
        };
    }

    public void loadImage(ImageView imageView, String imagePath) {
        this.loadImage(imageView, imagePath, 0, 0, null);
    }

    @Override
    public void loadImage(ImageView imageView, String imagePath, int width, int height) {
        this.loadImage(imageView, imagePath, width, height, null);
    }

    public void loadImage(ImageView imageView, String imagePath, int width, int height, LoadListener loadListener) {
        imageView.setTag((Object)imagePath);
        Bitmap bitmap = this.getImageFromCache(imagePath, width, height);
        if (bitmap == null) {
            imageView.setImageDrawable(DEFAULT_DRAWABLE);
            this.mExecutorService.execute(new TaskThread(this, imageView, imagePath, width, height, loadListener));
        } else {
            ImgBeanHolder holder = new ImgBeanHolder();
            holder.imageView = imageView;
            holder.imagePath = imagePath;
            holder.bitmap = bitmap;
            holder.loadListener = loadListener;
            LocalImageLoader.getHandler().post((Runnable)holder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap getImageFromCache(String key, int width, int height) {
        LruCache<String, Bitmap> lruCache = this.mLruCache;
        synchronized (lruCache) {
            return (Bitmap)this.mLruCache.get((Object)(key + width + height));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addImageToCache(String key, int width, int height, Bitmap bitmap) {
        if (this.getImageFromCache(key, width, height) == null && bitmap != null) {
            LruCache<String, Bitmap> lruCache = this.mLruCache;
            synchronized (lruCache) {
                this.mLruCache.put((Object)key, (Object)bitmap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bitmap readImage(String imagePath, int maxWidth, int maxHeight) {
        File imageFile = new File(imagePath);
        if (imageFile.exists()) {
            BufferedInputStream inputStream = null;
            try {
                int degrees;
                inputStream = new BufferedInputStream(new FileInputStream(imageFile));
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
                inputStream.close();
                options.inSampleSize = LocalImageLoader.calculateInSampleSize(options, maxWidth, maxHeight);
                options.inJustDecodeBounds = false;
                Bitmap decodeSampledBitmap = null;
                boolean decodeAttemptSuccess = false;
                while (!decodeAttemptSuccess) {
                    inputStream = new BufferedInputStream(new FileInputStream(imageFile));
                    try {
                        decodeSampledBitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
                        decodeAttemptSuccess = true;
                    }
                    catch (Exception e) {
                        options.inSampleSize *= 2;
                    }
                    inputStream.close();
                }
                if ((imagePath.endsWith(".jpg") || imagePath.endsWith(".JPG") || imagePath.endsWith(".jpeg") || imagePath.endsWith(".JPEG")) && (degrees = LocalImageLoader.readDegree(imagePath)) > 0) {
                    Matrix matrix = new Matrix();
                    matrix.setRotate((float)degrees, (float)(decodeSampledBitmap.getWidth() / 2), (float)(decodeSampledBitmap.getHeight() / 2));
                    decodeSampledBitmap = Bitmap.createBitmap((Bitmap)decodeSampledBitmap, (int)0, (int)0, (int)decodeSampledBitmap.getWidth(), (int)decodeSampledBitmap.getHeight(), (Matrix)matrix, (boolean)true);
                }
                Bitmap bitmap = decodeSampledBitmap;
                return bitmap;
            }
            catch (Exception options) {
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            while (height / inSampleSize > reqHeight || width / inSampleSize > reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    public static void measureSize(ImageView imageView, int[] viewSizes) {
        DisplayMetrics displayMetrics = imageView.getContext().getResources().getDisplayMetrics();
        ViewGroup.LayoutParams params = imageView.getLayoutParams();
        if (params == null) {
            viewSizes[0] = displayMetrics.widthPixels;
            viewSizes[1] = displayMetrics.heightPixels;
        } else {
            viewSizes[0] = params.width == -2 ? 0 : imageView.getMeasuredWidth();
            int n = viewSizes[1] = params.height == -2 ? 0 : imageView.getMeasuredWidth();
            if (viewSizes[0] <= 0) {
                viewSizes[0] = displayMetrics.widthPixels;
            }
            if (viewSizes[1] <= 0) {
                viewSizes[1] = displayMetrics.heightPixels;
            }
        }
    }

    public static int readDegree(String path) {
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    return 90;
                }
                case 3: {
                    return 180;
                }
                case 8: {
                    return 270;
                }
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Handler getHandler() {
        if (instanceHandler != null) return instanceHandler;
        Class<LocalImageLoader> clazz = LocalImageLoader.class;
        synchronized (LocalImageLoader.class) {
            if (instanceHandler != null) return instanceHandler;
            instanceHandler = new Handler(Looper.getMainLooper());
            // ** MonitorExit[var0] (shouldn't be in output)
            return instanceHandler;
        }
    }

    public static interface LoadListener {
        public void onLoadFinish(Bitmap var1, ImageView var2, String var3);
    }

    private static class ImgBeanHolder
    implements Runnable {
        Bitmap bitmap;
        ImageView imageView;
        String imagePath;
        LoadListener loadListener;

        private ImgBeanHolder() {
        }

        @Override
        public void run() {
            if (this.imagePath.equals(this.imageView.getTag())) {
                if (this.bitmap == null) {
                    this.imageView.setImageDrawable(DEFAULT_DRAWABLE);
                } else if (this.loadListener == null) {
                    this.imageView.setImageBitmap(this.bitmap);
                } else {
                    this.loadListener.onLoadFinish(this.bitmap, this.imageView, this.imagePath);
                }
            }
        }
    }

    private static class TaskThread
    implements Runnable {
        private LocalImageLoader loader;
        private ImageView mImageView;
        private String mImagePath;
        private int width;
        private int height;
        private LoadListener loadListener;

        TaskThread(LocalImageLoader loader, ImageView imageView, String imagePath, int width, int height, LoadListener loadListener) {
            this.loader = loader;
            this.mImagePath = imagePath;
            this.mImageView = imageView;
            this.width = width;
            this.height = height;
            this.loadListener = loadListener;
        }

        @Override
        public void run() {
            if (TextUtils.isEmpty((CharSequence)this.mImagePath)) {
                Log.e((String)"Album", (String)"The image path is null");
            } else {
                Bitmap bitmap;
                if (this.width != 0 && this.height != 0) {
                    bitmap = LocalImageLoader.readImage(this.mImagePath, this.width, this.height);
                } else {
                    int[] viewSizes = new int[2];
                    LocalImageLoader.measureSize(this.mImageView, viewSizes);
                    bitmap = LocalImageLoader.readImage(this.mImagePath, viewSizes[0], viewSizes[1]);
                }
                this.loader.addImageToCache(this.mImagePath, this.width, this.height, bitmap);
                ImgBeanHolder holder = new ImgBeanHolder();
                holder.bitmap = bitmap;
                holder.imageView = this.mImageView;
                holder.imagePath = this.mImagePath;
                holder.loadListener = this.loadListener;
                LocalImageLoader.getHandler().post((Runnable)holder);
            }
        }
    }
}

