/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.album.util;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import com.yanzhenjie.album.provider.CameraFileProvider;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class AlbumUtils {
    public static void startCamera(android.support.v4.app.Fragment fragment, int requestCode, File outPath) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        Uri uri = AlbumUtils.getUri(fragment.getContext(), outPath);
        intent.putExtra("output", (Parcelable)uri);
        fragment.startActivityForResult(intent, requestCode);
    }

    public static void startCamera(Fragment fragment, int requestCode, File outPath) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        Uri uri = AlbumUtils.getUri((Context)fragment.getActivity(), outPath);
        intent.putExtra("output", (Parcelable)uri);
        fragment.startActivityForResult(intent, requestCode);
    }

    public static void startCamera(Activity activity, int requestCode, File outPath) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        Uri uri = AlbumUtils.getUri((Context)activity, outPath);
        intent.putExtra("output", (Parcelable)uri);
        activity.startActivityForResult(intent, requestCode);
    }

    private static Uri getUri(Context context, File outPath) {
        Uri uri = Build.VERSION.SDK_INT < 24 ? Uri.fromFile((File)outPath) : CameraFileProvider.getUriForFile((Context)context, (String)CameraFileProvider.getFileProviderName(context), (File)outPath);
        return uri;
    }

    public static String getNowDateTime(String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.ENGLISH);
        Date curDate = new Date(System.currentTimeMillis());
        return formatter.format(curDate);
    }
}

