/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.album.widget.loading;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.View;
import com.yanzhenjie.album.widget.loading.LevelLoadingRenderer;
import com.yanzhenjie.album.widget.loading.LoadingDrawable;

public class LoadingView
extends AppCompatImageView {
    private LoadingDrawable mLoadingDrawable;

    public LoadingView(Context context) {
        super(context);
    }

    public LoadingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mLoadingDrawable = new LoadingDrawable(new LevelLoadingRenderer(context));
        this.setImageDrawable(this.mLoadingDrawable);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.startAnimation();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopAnimation();
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 0) {
            this.startAnimation();
        } else {
            this.stopAnimation();
        }
    }

    private void startAnimation() {
        if (this.mLoadingDrawable != null) {
            this.mLoadingDrawable.start();
        }
    }

    private void stopAnimation() {
        if (this.mLoadingDrawable != null) {
            this.mLoadingDrawable.stop();
        }
    }
}

