/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import com.yanzhenjie.permission.DefaultPermission;
import com.yanzhenjie.permission.Permission;
import com.yanzhenjie.permission.PermissionListener;
import com.yanzhenjie.permission.PermissionNo;
import com.yanzhenjie.permission.PermissionUtils;
import com.yanzhenjie.permission.PermissionYes;
import com.yanzhenjie.permission.Rationale;
import com.yanzhenjie.permission.RationaleDialog;
import com.yanzhenjie.permission.SettingDialog;
import com.yanzhenjie.permission.SettingExecutor;
import com.yanzhenjie.permission.SettingService;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class AndPermission {
    private static final String TAG = "AndPermission";

    public static boolean hasPermission(@NonNull Context context, String ... permissions) {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        for (String permission : permissions) {
            boolean hasPermission;
            boolean bl = hasPermission = ContextCompat.checkSelfPermission((Context)context, (String)permission) == 0;
            if (hasPermission) continue;
            return false;
        }
        return true;
    }

    public static boolean hasAlwaysDeniedPermission(@NonNull Activity activity, @NonNull List<String> deniedPermissions) {
        for (String deniedPermission : deniedPermissions) {
            if (PermissionUtils.shouldShowRationalePermissions(activity, deniedPermission)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    public static RationaleDialog rationaleDialog(@NonNull Context context, Rationale rationale) {
        return new RationaleDialog(context, rationale);
    }

    public static boolean hasAlwaysDeniedPermission(@NonNull android.support.v4.app.Fragment fragment, @NonNull List<String> deniedPermissions) {
        for (String deniedPermission : deniedPermissions) {
            if (PermissionUtils.shouldShowRationalePermissions(fragment, deniedPermission)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAlwaysDeniedPermission(@NonNull Fragment fragment, String ... deniedPermissions) {
        for (String deniedPermission : deniedPermissions) {
            if (PermissionUtils.shouldShowRationalePermissions(fragment, deniedPermission)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    public static SettingDialog defaultSettingDialog(@NonNull Activity activity, int requestCode) {
        return new SettingDialog((Context)activity, new SettingExecutor(activity, requestCode));
    }

    @NonNull
    public static SettingDialog defaultSettingDialog(@NonNull android.support.v4.app.Fragment fragment, int requestCode) {
        return new SettingDialog((Context)fragment.getActivity(), new SettingExecutor(fragment, requestCode));
    }

    @NonNull
    public static SettingDialog defaultSettingDialog(@NonNull Fragment fragment, int requestCode) {
        return new SettingDialog((Context)fragment.getActivity(), new SettingExecutor(fragment, requestCode));
    }

    @NonNull
    public static SettingService defineSettingDialog(@NonNull Activity activity, int requestCode) {
        return new SettingExecutor(activity, requestCode);
    }

    @NonNull
    public static SettingService defineSettingDialog(@NonNull android.support.v4.app.Fragment fragment, int requestCode) {
        return new SettingExecutor(fragment, requestCode);
    }

    @NonNull
    public static SettingService defineSettingDialog(@NonNull Fragment fragment, int requestCode) {
        return new SettingExecutor(fragment, requestCode);
    }

    @NonNull
    public static Permission with(@NonNull Activity activity) {
        return new DefaultPermission(activity);
    }

    @NonNull
    public static Permission with(@NonNull android.support.v4.app.Fragment fragment) {
        return new DefaultPermission(fragment);
    }

    @NonNull
    public static Permission with(@NonNull Fragment fragment) {
        return new DefaultPermission(fragment);
    }

    public static void send(@NonNull Activity activity, int requestCode, String ... permissions) {
        AndPermission.with(activity).requestCode(requestCode).permission(permissions).send();
    }

    public static void send(@NonNull android.support.v4.app.Fragment fragment, int requestCode, String ... permissions) {
        AndPermission.with(fragment).requestCode(requestCode).permission(permissions).send();
    }

    public static void send(@NonNull Fragment fragment, int requestCode, String ... permissions) {
        AndPermission.with(fragment).requestCode(requestCode).permission(permissions).send();
    }

    public static void onRequestPermissionsResult(@NonNull Activity activity, int requestCode, @NonNull String[] permissions, int[] grantResults) {
        AndPermission.callbackAnnotation(activity, requestCode, permissions, grantResults);
    }

    public static void onRequestPermissionsResult(@NonNull android.support.v4.app.Fragment fragment, int requestCode, @NonNull String[] permissions, int[] grantResults) {
        AndPermission.callbackAnnotation(fragment, requestCode, permissions, grantResults);
    }

    public static void onRequestPermissionsResult(@NonNull Fragment fragment, int requestCode, @NonNull String[] permissions, int[] grantResults) {
        AndPermission.callbackAnnotation(fragment, requestCode, permissions, grantResults);
    }

    private static void callbackAnnotation(@NonNull Object o, int requestCode, @NonNull String[] permissions, int[] grantResults) {
        ArrayList<String> grantedList = new ArrayList<String>();
        ArrayList<String> deniedList = new ArrayList<String>();
        for (int i = 0; i < permissions.length; ++i) {
            if (grantResults[i] == 0) {
                grantedList.add(permissions[i]);
                continue;
            }
            deniedList.add(permissions[i]);
        }
        boolean isAllGrant = deniedList.isEmpty();
        Class clazz = isAllGrant ? PermissionYes.class : PermissionNo.class;
        Method[] methods = AndPermission.findMethodForRequestCode(o.getClass(), clazz, requestCode);
        if (methods.length == 0) {
            Log.e((String)TAG, (String)"Not found the callback method, do you forget @PermissionYes or @permissionNo for callback method ? Or you can use PermissionListener.");
        } else {
            try {
                for (Method method : methods) {
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    method.invoke(o, isAllGrant ? grantedList : deniedList);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static <T extends Annotation> Method[] findMethodForRequestCode(@NonNull Class<?> source, @NonNull Class<T> annotation, int requestCode) {
        ArrayList<Method> methods = new ArrayList<Method>(1);
        for (Method method : source.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(annotation) || !AndPermission.isSameRequestCode(method, annotation, requestCode)) continue;
            methods.add(method);
        }
        return methods.toArray(new Method[methods.size()]);
    }

    private static <T extends Annotation> boolean isSameRequestCode(@NonNull Method method, @NonNull Class<T> annotation, int requestCode) {
        if (PermissionYes.class.equals(annotation)) {
            return method.getAnnotation(PermissionYes.class).value() == requestCode;
        }
        if (PermissionNo.class.equals(annotation)) {
            return method.getAnnotation(PermissionNo.class).value() == requestCode;
        }
        return false;
    }

    public static void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, int[] grantResults, @NonNull PermissionListener listener) {
        ArrayList<String> grantedList = new ArrayList<String>();
        ArrayList<String> deniedList = new ArrayList<String>();
        for (int i = 0; i < permissions.length; ++i) {
            if (grantResults[i] == 0) {
                grantedList.add(permissions[i]);
                continue;
            }
            deniedList.add(permissions[i]);
        }
        if (deniedList.isEmpty()) {
            listener.onSucceed(requestCode, grantedList);
        } else {
            listener.onFailed(requestCode, deniedList);
        }
    }

    private AndPermission() {
    }
}

