/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.util.Log;
import com.yanzhenjie.permission.AndPermission;
import com.yanzhenjie.permission.Permission;
import com.yanzhenjie.permission.PermissionUtils;
import com.yanzhenjie.permission.Rationale;
import com.yanzhenjie.permission.RationaleListener;
import java.util.ArrayList;

class DefaultPermission
implements Permission {
    private static final String TAG = "AndPermission";
    private String[] permissions;
    private String[] deniedPermissions;
    private int requestCode;
    private Object object;
    private RationaleListener listener;
    private Rationale rationale = new Rationale(){

        @Override
        public void cancel() {
            int[] results = new int[DefaultPermission.this.permissions.length];
            Context context = PermissionUtils.getContext(DefaultPermission.this.object);
            for (int i = 0; i < results.length; ++i) {
                results[i] = ActivityCompat.checkSelfPermission((Context)context, (String)DefaultPermission.this.permissions[i]);
            }
            DefaultPermission.onRequestPermissionsResult(DefaultPermission.this.object, DefaultPermission.this.requestCode, DefaultPermission.this.permissions, results);
        }

        @Override
        public void resume() {
            DefaultPermission.requestPermissions(DefaultPermission.this.object, DefaultPermission.this.requestCode, DefaultPermission.this.deniedPermissions);
        }
    };

    DefaultPermission(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("The object can not be null.");
        }
        this.object = o;
    }

    @Override
    @NonNull
    public Permission permission(String ... permissions) {
        if (permissions == null) {
            throw new IllegalArgumentException("The permissions can not be null.");
        }
        this.permissions = permissions;
        return this;
    }

    @Override
    @NonNull
    public Permission requestCode(int requestCode) {
        this.requestCode = requestCode;
        return this;
    }

    @Override
    @NonNull
    public Permission rationale(RationaleListener listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public void send() {
        if (Build.VERSION.SDK_INT < 23) {
            Context context = PermissionUtils.getContext(this.object);
            int[] grantResults = new int[this.permissions.length];
            PackageManager packageManager = context.getPackageManager();
            String packageName = context.getPackageName();
            int permissionCount = this.permissions.length;
            for (int i = 0; i < permissionCount; ++i) {
                grantResults[i] = packageManager.checkPermission(this.permissions[i], packageName);
            }
            DefaultPermission.onRequestPermissionsResult(this.object, this.requestCode, this.permissions, grantResults);
        } else {
            this.deniedPermissions = DefaultPermission.getDeniedPermissions(this.object, this.permissions);
            if (this.deniedPermissions.length > 0) {
                boolean showRationale = PermissionUtils.shouldShowRationalePermissions(this.object, this.deniedPermissions);
                if (showRationale && this.listener != null) {
                    this.listener.showRequestPermissionRationale(this.requestCode, this.rationale);
                } else {
                    this.rationale.resume();
                }
            } else {
                int[] grantResults = new int[this.permissions.length];
                int permissionCount = this.permissions.length;
                for (int i = 0; i < permissionCount; ++i) {
                    grantResults[i] = 0;
                }
                DefaultPermission.onRequestPermissionsResult(this.object, this.requestCode, this.permissions, grantResults);
            }
        }
    }

    private static String[] getDeniedPermissions(Object o, String ... permissions) {
        Context context = PermissionUtils.getContext(o);
        ArrayList<String> deniedList = new ArrayList<String>(1);
        for (String permission : permissions) {
            if (AndPermission.hasPermission(context, permission)) continue;
            deniedList.add(permission);
        }
        return deniedList.toArray(new String[deniedList.size()]);
    }

    @TargetApi(value=23)
    private static void requestPermissions(Object o, int requestCode, String ... permissions) {
        if (o instanceof Activity) {
            ActivityCompat.requestPermissions((Activity)((Activity)o), (String[])permissions, (int)requestCode);
        } else if (o instanceof android.support.v4.app.Fragment) {
            ((android.support.v4.app.Fragment)o).requestPermissions(permissions, requestCode);
        } else if (o instanceof Fragment) {
            ((Fragment)o).requestPermissions(permissions, requestCode);
            Log.e((String)TAG, (String)("The " + o.getClass().getName() + " is not support " + "requestPermissions()"));
        }
    }

    @TargetApi(value=23)
    private static void onRequestPermissionsResult(Object o, int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (o instanceof Activity) {
            if (Build.VERSION.SDK_INT >= 23) {
                ((Activity)o).onRequestPermissionsResult(requestCode, permissions, grantResults);
            } else if (o instanceof ActivityCompat.OnRequestPermissionsResultCallback) {
                ((ActivityCompat.OnRequestPermissionsResultCallback)o).onRequestPermissionsResult(requestCode, permissions, grantResults);
            } else {
                Log.e((String)TAG, (String)("The " + o.getClass().getName() + " is not support " + "onRequestPermissionsResult()"));
            }
        } else if (o instanceof android.support.v4.app.Fragment) {
            ((android.support.v4.app.Fragment)o).onRequestPermissionsResult(requestCode, permissions, grantResults);
        } else if (o instanceof Fragment) {
            ((Fragment)o).onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }
}

