/*
 * Decompiled with CFR 0.152.
 */
package com.zhy.autolayout.attr;

import android.view.View;
import com.zhy.autolayout.utils.AutoUtils;
import com.zhy.autolayout.utils.L;

public abstract class AutoAttr {
    public static final int BASE_WIDTH = 1;
    public static final int BASE_HEIGHT = 2;
    public static final int BASE_DEFAULT = 3;
    protected int pxVal;
    protected int baseWidth;
    protected int baseHeight;

    public AutoAttr(int pxVal, int baseWidth, int baseHeight) {
        this.pxVal = pxVal;
        this.baseWidth = baseWidth;
        this.baseHeight = baseHeight;
    }

    public void apply(View view) {
        int val;
        boolean log;
        boolean bl = log = view.getTag() != null && view.getTag().toString().equals("auto");
        if (log) {
            L.e(" pxVal = " + this.pxVal + " ," + this.getClass().getSimpleName());
        }
        if (this.useDefault()) {
            int n = val = this.defaultBaseWidth() ? this.getPercentWidthSize() : this.getPercentHeightSize();
            if (log) {
                L.e(" useDefault val= " + val);
            }
        } else if (this.baseWidth()) {
            val = this.getPercentWidthSize();
            if (log) {
                L.e(" baseWidth val= " + val);
            }
        } else {
            val = this.getPercentHeightSize();
            if (log) {
                L.e(" baseHeight val= " + val);
            }
        }
        if (val > 0) {
            val = Math.max(val, 1);
        }
        this.execute(view, val);
    }

    protected int getPercentWidthSize() {
        return AutoUtils.getPercentWidthSizeBigger(this.pxVal);
    }

    protected int getPercentHeightSize() {
        return AutoUtils.getPercentHeightSizeBigger(this.pxVal);
    }

    protected boolean baseWidth() {
        return this.contains(this.baseWidth, this.attrVal());
    }

    protected boolean useDefault() {
        return !this.contains(this.baseHeight, this.attrVal()) && !this.contains(this.baseWidth, this.attrVal());
    }

    protected boolean contains(int baseVal, int flag) {
        return (baseVal & flag) != 0;
    }

    protected abstract int attrVal();

    protected abstract boolean defaultBaseWidth();

    protected abstract void execute(View var1, int var2);

    public String toString() {
        return "AutoAttr{pxVal=" + this.pxVal + ", baseWidth=" + this.baseWidth() + ", defaultBaseWidth=" + this.defaultBaseWidth() + '}';
    }
}

