/*
 * Decompiled with CFR 0.152.
 */
package com.zhy.autolayout.attr;

import android.os.Build;
import android.view.View;
import com.zhy.autolayout.attr.AutoAttr;
import java.lang.reflect.Field;

public class MinHeightAttr
extends AutoAttr {
    public MinHeightAttr(int pxVal, int baseWidth, int baseHeight) {
        super(pxVal, baseWidth, baseHeight);
    }

    @Override
    protected int attrVal() {
        return 32768;
    }

    @Override
    protected boolean defaultBaseWidth() {
        return false;
    }

    @Override
    protected void execute(View view, int val) {
        try {
            view.setMinimumHeight(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static MinHeightAttr generate(int val, int baseFlag) {
        MinHeightAttr attr = null;
        switch (baseFlag) {
            case 1: {
                attr = new MinHeightAttr(val, 32768, 0);
                break;
            }
            case 2: {
                attr = new MinHeightAttr(val, 0, 32768);
                break;
            }
            case 3: {
                attr = new MinHeightAttr(val, 0, 0);
            }
        }
        return attr;
    }

    public static int getMinHeight(View view) {
        if (Build.VERSION.SDK_INT >= 16) {
            return view.getMinimumHeight();
        }
        try {
            Field minHeight = view.getClass().getField("mMinHeight");
            minHeight.setAccessible(true);
            return (Integer)minHeight.get(view);
        }
        catch (Exception exception) {
            return 0;
        }
    }
}

