/*
 * Decompiled with CFR 0.152.
 */
package com.zhy.autolayout.attr;

import android.view.View;
import com.zhy.autolayout.attr.AutoAttr;

public class PaddingLeftAttr
extends AutoAttr {
    public PaddingLeftAttr(int pxVal, int baseWidth, int baseHeight) {
        super(pxVal, baseWidth, baseHeight);
    }

    @Override
    protected int attrVal() {
        return 512;
    }

    @Override
    protected boolean defaultBaseWidth() {
        return true;
    }

    @Override
    protected void execute(View view, int val) {
        int l = val;
        int t = view.getPaddingTop();
        int r = view.getPaddingRight();
        int b = view.getPaddingBottom();
        view.setPadding(l, t, r, b);
    }

    public static PaddingLeftAttr generate(int val, int baseFlag) {
        PaddingLeftAttr attr = null;
        switch (baseFlag) {
            case 1: {
                attr = new PaddingLeftAttr(val, 512, 0);
                break;
            }
            case 2: {
                attr = new PaddingLeftAttr(val, 0, 512);
                break;
            }
            case 3: {
                attr = new PaddingLeftAttr(val, 0, 0);
            }
        }
        return attr;
    }
}

