/*
 * Decompiled with CFR 0.152.
 */
package com.zhy.autolayout.utils;

import android.view.View;
import com.zhy.autolayout.AutoLayoutInfo;
import com.zhy.autolayout.R;
import com.zhy.autolayout.config.AutoLayoutConifg;

public class AutoUtils {
    public static void auto(View view) {
        AutoUtils.autoSize(view);
        AutoUtils.autoPadding(view);
        AutoUtils.autoMargin(view);
        AutoUtils.autoTextSize(view, 3);
    }

    public static void auto(View view, int attrs, int base) {
        AutoLayoutInfo autoLayoutInfo = AutoLayoutInfo.getAttrFromView(view, attrs, base);
        if (autoLayoutInfo != null) {
            autoLayoutInfo.fillAttrs(view);
        }
    }

    public static void autoTextSize(View view) {
        AutoUtils.auto(view, 4, 3);
    }

    public static void autoTextSize(View view, int base) {
        AutoUtils.auto(view, 4, base);
    }

    public static void autoMargin(View view) {
        AutoUtils.auto(view, 16, 3);
    }

    public static void autoMargin(View view, int base) {
        AutoUtils.auto(view, 16, base);
    }

    public static void autoPadding(View view) {
        AutoUtils.auto(view, 8, 3);
    }

    public static void autoPadding(View view, int base) {
        AutoUtils.auto(view, 8, base);
    }

    public static void autoSize(View view) {
        AutoUtils.auto(view, 3, 3);
    }

    public static void autoSize(View view, int base) {
        AutoUtils.auto(view, 3, base);
    }

    public static boolean autoed(View view) {
        Object tag = view.getTag(R.id.id_tag_autolayout_size);
        if (tag != null) {
            return true;
        }
        view.setTag(R.id.id_tag_autolayout_size, (Object)"Just Identify");
        return false;
    }

    public static float getPercentWidth1px() {
        int screenWidth = AutoLayoutConifg.getInstance().getScreenWidth();
        int designWidth = AutoLayoutConifg.getInstance().getDesignWidth();
        return 1.0f * (float)screenWidth / (float)designWidth;
    }

    public static float getPercentHeight1px() {
        int screenHeight = AutoLayoutConifg.getInstance().getScreenHeight();
        int designHeight = AutoLayoutConifg.getInstance().getDesignHeight();
        return 1.0f * (float)screenHeight / (float)designHeight;
    }

    public static int getPercentWidthSize(int val) {
        int screenWidth = AutoLayoutConifg.getInstance().getScreenWidth();
        int designWidth = AutoLayoutConifg.getInstance().getDesignWidth();
        return (int)((float)val * 1.0f / (float)designWidth * (float)screenWidth);
    }

    public static int getPercentWidthSizeBigger(int val) {
        int designWidth;
        int screenWidth = AutoLayoutConifg.getInstance().getScreenWidth();
        int res = val * screenWidth;
        if (res % (designWidth = AutoLayoutConifg.getInstance().getDesignWidth()) == 0) {
            return res / designWidth;
        }
        return res / designWidth + 1;
    }

    public static int getPercentHeightSizeBigger(int val) {
        int designHeight;
        int screenHeight = AutoLayoutConifg.getInstance().getScreenHeight();
        int res = val * screenHeight;
        if (res % (designHeight = AutoLayoutConifg.getInstance().getDesignHeight()) == 0) {
            return res / designHeight;
        }
        return res / designHeight + 1;
    }

    public static int getPercentHeightSize(int val) {
        int screenHeight = AutoLayoutConifg.getInstance().getScreenHeight();
        int designHeight = AutoLayoutConifg.getInstance().getDesignHeight();
        return (int)((float)val * 1.0f / (float)designHeight * (float)screenHeight);
    }
}

