/*
 * Decompiled with CFR 0.152.
 */
package com.zhy.autolayout.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;

public class ScreenUtils {
    public static int getStatusBarHeight(Context context) {
        int result = 0;
        try {
            int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
            if (resourceId > 0) {
                result = context.getResources().getDimensionPixelSize(resourceId);
            }
        }
        catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static int[] getScreenSize(Context context, boolean useDeviceSize) {
        int[] size = new int[2];
        WindowManager w = (WindowManager)context.getSystemService("window");
        Display d = w.getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        d.getMetrics(metrics);
        int widthPixels = metrics.widthPixels;
        int heightPixels = metrics.heightPixels;
        if (!useDeviceSize) {
            size[0] = widthPixels;
            size[1] = heightPixels - ScreenUtils.getStatusBarHeight(context);
            return size;
        }
        if (Build.VERSION.SDK_INT >= 14 && Build.VERSION.SDK_INT < 17) {
            try {
                widthPixels = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)d, new Object[0]);
                heightPixels = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)d, new Object[0]);
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (Build.VERSION.SDK_INT >= 17) {
            try {
                Point realSize = new Point();
                Display.class.getMethod("getRealSize", Point.class).invoke((Object)d, realSize);
                widthPixels = realSize.x;
                heightPixels = realSize.y;
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        size[0] = widthPixels;
        size[1] = heightPixels;
        return size;
    }
}

