/*
 * Decompiled with CFR 0.152.
 */
package com.zhy.autolayout.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.zhy.autolayout.AutoLayoutInfo;
import com.zhy.autolayout.R;
import com.zhy.autolayout.utils.AutoLayoutHelper;
import com.zhy.autolayout.utils.AutoUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class MetroLayout
extends ViewGroup {
    private final AutoLayoutHelper mHelper = new AutoLayoutHelper(this);
    private List<MetroBlock> mAvailablePos = new ArrayList<MetroBlock>();
    private int mDivider;

    public MetroLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MetroLayout);
        this.mDivider = a.getDimensionPixelOffset(R.styleable.MetroLayout_metro_divider, 0);
        this.mDivider = AutoUtils.getPercentWidthSizeBigger(this.mDivider);
        a.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.randomColor();
        if (!this.isInEditMode()) {
            this.mHelper.adjustChildren();
        }
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private void randomColor() {
        Random r = new Random(255L);
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            View v = this.getChildAt(i);
            v.setBackgroundColor(Color.argb((int)100, (int)r.nextInt(), (int)r.nextInt(), (int)r.nextInt()));
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.initAvailablePosition();
        int left = 0;
        int top = 0;
        int divider = this.mDivider;
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            View v = this.getChildAt(i);
            if (v.getVisibility() == 8) continue;
            MetroBlock newPos = this.findAvailablePos(v);
            left = newPos.left;
            top = newPos.top;
            int childWidth = v.getMeasuredWidth();
            int childHeight = v.getMeasuredHeight();
            int right = left + childWidth;
            int bottom = top + childHeight;
            v.layout(left, top, right, bottom);
            if (childWidth + divider < newPos.width) {
                newPos.left += childWidth + divider;
                newPos.width -= childWidth + divider;
            } else {
                this.mAvailablePos.remove(newPos);
            }
            MetroBlock p = new MetroBlock();
            p.left = left;
            p.top = bottom + divider;
            p.width = childWidth;
            this.mAvailablePos.add(p);
            this.mergeAvailablePosition();
        }
    }

    private void mergeAvailablePosition() {
        if (this.mAvailablePos.size() <= 1) {
            return;
        }
        ArrayList<MetroBlock> needRemoveBlocks = new ArrayList<MetroBlock>();
        MetroBlock one = this.mAvailablePos.get(0);
        MetroBlock two = this.mAvailablePos.get(1);
        int n = this.mAvailablePos.size();
        for (int i = 1; i < n - 1; ++i) {
            if (one.top == two.top) {
                one.width += two.width;
                needRemoveBlocks.add(one);
                two.left = one.left;
                two = this.mAvailablePos.get(i + 1);
                continue;
            }
            one = this.mAvailablePos.get(i);
            two = this.mAvailablePos.get(i + 1);
        }
        this.mAvailablePos.removeAll(needRemoveBlocks);
    }

    private void initAvailablePosition() {
        this.mAvailablePos.clear();
        MetroBlock first = new MetroBlock();
        first.left = this.getPaddingLeft();
        first.top = this.getPaddingTop();
        first.width = this.getMeasuredWidth();
        this.mAvailablePos.add(first);
    }

    private MetroBlock findAvailablePos(View view) {
        MetroBlock p = new MetroBlock();
        if (this.mAvailablePos.size() == 0) {
            p.left = this.getPaddingLeft();
            p.top = this.getPaddingTop();
            p.width = this.getMeasuredWidth();
            return p;
        }
        int min = this.mAvailablePos.get((int)0).top;
        MetroBlock minHeightPos = this.mAvailablePos.get(0);
        for (MetroBlock _p : this.mAvailablePos) {
            if (_p.top >= min) continue;
            min = _p.top;
            minHeightPos = _p;
        }
        return minHeightPos;
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams
    implements AutoLayoutHelper.AutoLayoutParams {
        private AutoLayoutInfo mAutoLayoutInfo;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            this.mAutoLayoutInfo = AutoLayoutHelper.getAutoLayoutInfo(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(LayoutParams source) {
            this((ViewGroup.LayoutParams)source);
            this.mAutoLayoutInfo = source.mAutoLayoutInfo;
        }

        @Override
        public AutoLayoutInfo getAutoLayoutInfo() {
            return this.mAutoLayoutInfo;
        }
    }

    private static class MetroBlock {
        int left;
        int top;
        int width;

        private MetroBlock() {
        }
    }
}

