/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.app;

import android.os.Bundle;
import android.util.Log;
import in.srain.cube.app.CubeFragmentActivity;
import in.srain.cube.app.lifecycle.IComponentContainer;
import in.srain.cube.app.lifecycle.LifeCycleComponent;
import in.srain.cube.app.lifecycle.LifeCycleComponentManager;
import in.srain.cube.util.Debug;

public abstract class XActivity
extends CubeFragmentActivity
implements IComponentContainer {
    private LifeCycleComponentManager mComponentContainer = new LifeCycleComponentManager();
    private static final boolean DEBUG = Debug.DEBUG_LIFE_CYCLE;

    protected void onRestart() {
        super.onStart();
        this.mComponentContainer.onBecomesVisibleFromTotallyInvisible();
        if (DEBUG) {
            this.showStatus("onRestart");
        }
    }

    protected void onPause() {
        super.onPause();
        this.mComponentContainer.onBecomesPartiallyInvisible();
        if (DEBUG) {
            this.showStatus("onPause");
        }
    }

    protected void onResume() {
        super.onResume();
        this.mComponentContainer.onBecomesVisibleFromPartiallyInvisible();
        if (DEBUG) {
            this.showStatus("onResume");
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (DEBUG) {
            this.showStatus("onCreate");
        }
    }

    protected void onStop() {
        super.onStop();
        this.mComponentContainer.onBecomesTotallyInvisible();
        if (DEBUG) {
            this.showStatus("onStop");
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mComponentContainer.onDestroy();
        if (DEBUG) {
            this.showStatus("onDestroy");
        }
    }

    @Override
    public void addComponent(LifeCycleComponent component) {
        this.mComponentContainer.addComponent(component);
    }

    private void showStatus(String status) {
        String[] className = this.getClass().getName().split("\\.");
        Log.d((String)"cube-lifecycle", (String)String.format("%s %s", className[className.length - 1], status));
    }
}

